% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_gc.R
\name{inv_gc}
\alias{inv_gc}
\title{Run invisible garbage collection}
\usage{
inv_gc(.data = NULL)
}
\arguments{
\item{.data}{Optional. If null runs `gc()` silently. Else returns the same object unaltered.}
}
\description{
Run garbage collection without the `gc()` output. Can also be run in the middle of a long pipe chain. Useful for large datasets.
}
\examples{
inv_gc()

df <- data.table::data.table(col1 = 1, col2 = 2)

df \%>\%
  inv_gc() \%>\%
  dt_select(col1, col2)
}
