% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyfeed.R
\name{tidyfeed}
\alias{tidyfeed}
\title{Extract a tidy data frame from RSS and Atom and JSON feeds}
\usage{
tidyfeed(feed, sf = TRUE, config = list())
}
\arguments{
\item{feed}{(\code{character}). The url for the feed that you want to parse.}

\item{sf}{. If TRUE, returns sf dataframe.}

\item{config}{Additional configuration settings such as http
authentication (\code{\link[=authenticate]{authenticate()}}), additional headers
(\code{\link[=add_headers]{add_headers()}}), cookies (\code{\link[=set_cookies]{set_cookies()}}) etc.
See \code{\link[=config]{config()}} for full details and list of helpers.}
}
\description{
\code{tidyfeed()} downloads and parses rss feeds. The function
produces a tidy data frame, easy to use for further manipulation and
analysis.
}
\examples{
\dontrun{
# Atom feed:
tidyfeed("http://journal.r-project.org/rss.atom")
# rss/xml:
tidyfeed("http://fivethirtyeight.com/all/feed")
# jsonfeed:
tidyfeed("https://daringfireball.net/feeds/json")
# georss:
tidyfeed("http://www.geonames.org/recent-changes.xml")
}
}
\references{
\url{https://en.wikipedia.org/wiki/RSS}
}
\author{
Robert Myles McDonnell, \email{robertmylesmcdonnell@gmail.com}
}
