% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.feature_calculations}
\alias{plot.feature_calculations}
\title{Produce a plot for a feature_calculations object}
\usage{
\method{plot}{feature_calculations}(
  x,
  type = c("quality", "matrix", "cor"),
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  cor_method = c("pearson", "spearman"),
  ...
)
}
\arguments{
\item{x}{the \code{feature_calculations} object containing the raw feature matrix produced by \code{calculate_features}}

\item{type}{\code{string} specifying the type of plot to draw. Defaults to \code{"quality"}}

\item{method}{\code{string} specifying a rescaling/normalising method to apply if \code{type = "matrix"} or if \code{type = "cor"}. Defaults to \code{"z-score"}}

\item{clust_method}{\code{string} specifying the hierarchical clustering method to use if \code{type = "matrix"} or if \code{type = "cor"}. Defaults to \code{"average"}}

\item{cor_method}{\code{string} specifying the correlation method to use if \code{type = "cor"}. Defaults to \code{"pearson"}}

\item{...}{Arguments to be passed to methods}
}
\value{
object of class \code{ggplot} that contains the graphic
}
\description{
Produce a plot for a feature_calculations object
}
\author{
Trent Henderson
}
