% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduce_PCA.R
\name{dim_reduce}
\alias{dim_reduce}
\title{PCA-based Dimension Reduction and Prewhitening}
\usage{
dim_reduce(X, Q = NULL, Q_max = 100)
}
\arguments{
\item{X}{\eqn{V \times T} fMRI timeseries data matrix, centered by columns.}

\item{Q}{Number of latent dimensions to estimate. If \code{NULL} (default),
estimated using PESEL (Sobczyka et al. 2020).}

\item{Q_max}{Maximal number of principal components for automatic
dimensionality selection with PESEL. Default: \code{100}.}
}
\value{
A list containing the dimension-reduced data (\code{data_reduced}, a
\eqn{V \times Q} matrix), prewhitening/dimension reduction matrix (\code{H},
a \eqn{QxT} matrix) and its (pseudo-)inverse (\code{Hinv}, a \eqn{TxQ}
matrix), the noise variance (\code{sigma_sq}), the correlation matrix of the
dimension-reduced data (\code{C_diag}, a \eqn{QxQ} matrix), and the
dimensionality (\code{Q}).
}
\description{
Performs dimension reduction and prewhitening based on probabilistic PCA using
SVD. If dimensionality is not specified, it is estimated using the method
described in Minka (2008).
}
\examples{
nT <- 30
nV <- 400
nQ <- 7
X <- matrix(rnorm(nV*nQ), nrow=nV) \%*\% diag(seq(nQ, 1)) \%*\% matrix(rnorm(nQ*nT), nrow=nQ) 
dim_reduce(X, Q=nQ)

}
