% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circle_stats}
\alias{circle_stats}
\alias{circular_mean}
\alias{circular_var}
\alias{circular_sd}
\alias{circular_median}
\alias{circular_quantiles}
\alias{circular_IQR}
\alias{sample_circular_dispersion}
\title{Summary Statistics of Circular Data}
\usage{
circular_mean(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_var(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_sd(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_median(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_quantiles(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_IQR(x, w = NULL, axial = TRUE, na.rm = TRUE)

sample_circular_dispersion(x, w = NULL, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
numeric vector
}
\description{
Calculate the (weighted median) and standard deviation
of orientation data.
}
\note{
Weighting may be the reciprocal of the data uncertainties.

Weightings have no effect on quasi-median and quasi-quantiles if
\code{length(x) \%\% 2 != 1} and \code{length(x) \%\% 4 == 0}, respectively.
}
\examples{
set.seed(1)
x <- rvm(10, 0, 100) \%\% 180
unc <- stats::runif(100, 0, 10)
circular_mean(x, 1 / unc)
circular_var(x, 1 / unc)
sample_circular_dispersion(x, 1 / unc)
circular_sd(x, 1 / unc)
circular_median(x, 1 / unc)
circular_quantiles(x, 1 / unc)
circular_IQR(x, 1 / unc)

data("san_andreas")
circular_mean(san_andreas$azi)
circular_mean(san_andreas$azi, 1 / san_andreas$unc)
circular_median(san_andreas$azi)
circular_median(san_andreas$azi, 1 / san_andreas$unc)
circular_quantiles(san_andreas$azi)
circular_quantiles(san_andreas$azi, 1 / san_andreas$unc)
circular_var(san_andreas$azi)
circular_var(san_andreas$azi, 1 / san_andreas$unc)
sample_circular_dispersion(san_andreas$azi, 1 / san_andreas$unc)

data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
circular_mean(sa.por$azi.PoR, 1 / san_andreas$unc)
circular_median(sa.por$azi.PoR, 1 / san_andreas$unc)
circular_var(sa.por$azi.PoR, 1 / san_andreas$unc)
sample_circular_dispersion(sa.por$azi.PoR, 1 / san_andreas$unc)
circular_quantiles(sa.por$azi.PoR, 1 / san_andreas$unc)
}
\references{
Mardia, K.V. (1972). Statistics of Directional Data: Probability and
Mathematical Statistics. London: Academic Press.

Mardia, K.V., and Jupp, P.E (1999). Directional Statistics,
Wiley Series in Probability and Statistics. John Wiley & Sons, Inc.,
Hoboken, NJ, USA. \doi{10.1002/9780470316979}

Ziegler, M. O.; Heidbach O. (2019). Manual of the Matlab Script
Stress2Grid v1.1. \emph{WSM Technical Report} 19-02,
GFZ German Research Centre for Geosciences. \doi{10.2312/wsm.2019.002}

Heidbach, O., Tingay, M., Barth, A., Reinecker, J., Kurfess, D., & Mueller,
B. (2010). Global crustal stress pattern based on the World Stress Map
database release 2008. \emph{Tectonophysics} \strong{482}, 3<U+2013>15,
\doi{10.1016/j.tecto.2009.07.023}
}
