% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{coordinates2}
\alias{coordinates2}
\alias{cartesian_to_spherical}
\alias{spherical_to_cartesian}
\alias{spherical_to_geographical}
\title{Coordinate Transformations}
\usage{
cartesian_to_spherical(n)

spherical_to_cartesian(p)

spherical_to_geographical(p)
}
\arguments{
\item{n}{Cartesian coordinates (x, y, z) as three-column vector}

\item{p}{Spherical coordinates (colatitude, azimuth) as two-column vector}
}
\value{
Functions return a (2- or 3-dimensional) vector representing a
point in the requested coordinate system.
}
\description{
Converts vector between Cartesian and spherical coordinate
systems
}
\examples{
n <- c(1, -2, 3)
cartesian_to_spherical(n)
p <- c(50, 10)
spherical_to_cartesian(p)
}
\seealso{
\code{\link[=cartesian_to_geographical]{cartesian_to_geographical()}} and \code{\link[=geographical_to_cartesian]{geographical_to_cartesian()}} for
conversions to geographical coordinates
}
