% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Create the server and UI function for the \code{shiny} app}
\usage{
init(
  data,
  modules,
  filter = teal_slices(),
  title = build_app_title(),
  header = tags$p(),
  footer = tags$p(),
  id = character(0)
)
}
\arguments{
\item{data}{(\code{teal_data} or \code{teal_data_module})
For constructing the data object, refer to \code{\link[=teal_data]{teal_data()}} and \code{\link[=teal_data_module]{teal_data_module()}}.}

\item{modules}{(\code{list} or \code{teal_modules} or \code{teal_module})
nested list of \code{teal_modules} or \code{teal_module} objects or a single
\code{teal_modules} or \code{teal_module} object. These are the specific output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{filter}{(\code{teal_slices})
Specifies the initial filter using \code{\link[=teal_slices]{teal_slices()}}.}

\item{title}{(\code{shiny.tag} or \code{character(1)})
The browser window title. Defaults to a title "teal app" with the icon of NEST.
Can be created using the \code{build_app_title()} or
by passing a valid \code{shiny.tag} which is a head tag with title and link tag.}

\item{header}{(\code{shiny.tag} or \code{character(1)})
The header of the app.}

\item{footer}{(\code{shiny.tag} or \code{character(1)})
The footer of the app.}

\item{id}{(\code{character})
Optional string specifying the \code{shiny} module id in cases it is used as a \code{shiny} module
rather than a standalone \code{shiny} app. This is a legacy feature.}
}
\value{
Named list with server and UI functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

End-users: This is the most important function for you to start a
\code{teal} app that is composed of \code{teal} modules.
}
\details{
When initializing the \code{teal} app, if \code{datanames} are not set for the \code{teal_data} object,
defaults from the \code{teal_data} environment will be used.
}
\examples{
app <- init(
  data = teal_data(
    new_iris = transform(iris, id = seq_len(nrow(iris))),
    new_mtcars = transform(mtcars, id = seq_len(nrow(mtcars))),
    code = "
      new_iris <- transform(iris, id = seq_len(nrow(iris)))
      new_mtcars <- transform(mtcars, id = seq_len(nrow(mtcars)))
    "
  ),
  modules = modules(
    module(
      label = "data source",
      server = function(input, output, session, data) {},
      ui = function(id, ...) div(p("information about data source")),
      datanames = "all"
    ),
    example_module(label = "example teal module"),
    module(
      "Iris Sepal.Length histogram",
      server = function(input, output, session, data) {
        output$hist <- renderPlot(
          hist(data()[["new_iris"]]$Sepal.Length)
        )
      },
      ui = function(id, ...) {
        ns <- NS(id)
        plotOutput(ns("hist"))
      },
      datanames = "new_iris"
    )
  ),
  filter = teal_slices(
    teal_slice(dataname = "new_iris", varname = "Species"),
    teal_slice(dataname = "new_iris", varname = "Sepal.Length"),
    teal_slice(dataname = "new_mtcars", varname = "cyl"),
    exclude_varnames = list(new_iris = c("Sepal.Width", "Petal.Width")),
    module_specific = TRUE,
    mapping = list(
      `example teal module` = "new_iris Species",
      `Iris Sepal.Length histogram` = "new_iris Species",
      global_filters = "new_mtcars cyl"
    )
  ),
  title = "App title",
  header = tags$h1("Sample App"),
  footer = tags$p("Copyright 2017 - 2023")
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
