% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wholesale}
\alias{wholesale}
\title{Wholesale customers dataset}
\format{
A data frame containing 440 observations in 8 variables (6 numerical and two categorical). 
The variables are as follows:

\itemize{
     \item \code{Region} Customers' Region - Lisbon (coded as 1), Porto (coded as 2) or Other (coded as 3)
     \item \code{Fresh} Annual spending on fresh products
     \item \code{Milk} Annual spending on milk products
     \item \code{Grocery} Annual spending on grocery products
     \item \code{Frozen} Annual spending on frozen products
     \item \code{Detergents} Annual spending on detergents and paper products
     \item \code{Delicatessen} Annual spending on and delicatessen products
     \item \code{Channel}  Customers' Channel - Horeca (Hotel/Restaurant/Café) or 
             Retail channel. Horeca is coded as 1 and Retail channel is coded as 2
 }
}
\source{
Abreu, N. (2011). Analise do perfil do cliente Recheio e desenvolvimento de 
 um sistema promocional. Mestrado em Marketing, ISCTE-IUL, Lisbon. 
 url={https://api.semanticscholar.org/CorpusID:124027622}
}
\usage{
data(wholesale)
}
\description{
The data set refers to clients of a wholesale distributor. It includes the annual 
 spending in monetary units  on diverse product categories.
}
\examples{
#--- EXAMPLE 1 ------------------------------------------ 
data (wholesale) 
x <- wholesale[, -c(1, ncol(wholesale))] 
clus <- tclust(x, k=3, alpha=0.1, nstart=200, niter1=3, niter2=17, 
   nkeep=10, opt="HARD", equal.weights=FALSE, restr.fact=50, trace=TRUE) 
 plot (x, col=clus$cluster+1)
 plot(clus)
}
\keyword{datasets}
