% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load.R
\name{tar_load}
\alias{tar_load}
\title{Load the values of targets.}
\usage{
tar_load(
  names,
  branches = NULL,
  meta = tar_meta(targets_only = TRUE, store = store),
  strict = TRUE,
  silent = FALSE,
  envir = parent.frame(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Names of the targets to load.
The object supplied to \code{names} should be a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{strict}{Logical of length 1, whether to error out
if one of the selected targets is in the metadata
but cannot be loaded.
Set to \code{FALSE} to just load the targets in the metadata
that can be loaded and skip the others.}

\item{silent}{Logical of length 1. Only relevant when
\code{strict} is \code{FALSE}. If \code{silent} is \code{FALSE}
and \code{strict} is \code{FALSE}, then a message will be printed
if a target is in the metadata but cannot be loaded.
However, load failures
will not stop other targets from being loaded.}

\item{envir}{Environment to put the loaded targets.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Nothing.
}
\description{
Load the return values of targets into the current environment
(or the environment of your choosing). For a typical target, the return
value lives in a file in \verb{_targets/objects/}. For dynamic files (i.e.
\code{format = "file"}) the paths loaded in place of the values.
\code{\link[=tar_load_everything]{tar_load_everything()}} is shorthand for \code{tar_load(everything())}
to load all targets.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.


Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\section{Cloud target data versioning}{

Some buckets in Amazon S3 or Google Cloud Storage are "versioned",
which means they track historical versions of each data object.
If you use \code{targets} with cloud storage
(\url{https://books.ropensci.org/targets/cloud-storage.html})
and versioning is turned on, then \code{targets} will record each
version of each target in its metadata.

Functions like \code{\link[=tar_read]{tar_read()}}
and \code{\link[=tar_load]{tar_load()}} load the version recorded in the local metadata,
which may not be the same as the "current" version of the
object in the bucket. Likewise, functions \code{\link[=tar_delete]{tar_delete()}}
and \code{\link[=tar_destroy]{tar_destroy()}} only remove
the version ID of each target as recorded in the local
metadata.

If you want to interact with the \emph{latest} version of an object
instead of the version ID recorded in the local metadata,
then you will need to delete the object from the metadata.
\enumerate{
\item Make sure your local copy of the metadata is current and
up to date. You may need to run \code{\link[=tar_meta_download]{tar_meta_download()}} or
\code{\link[=tar_meta_sync]{tar_meta_sync()}} first.
\item Run \code{\link[=tar_unversion]{tar_unversion()}} to remove the recorded version IDs of
your targets in the local metadata.
\item With the version IDs gone from the local metadata,
functions like \code{\link[=tar_read]{tar_read()}} and \code{\link[=tar_destroy]{tar_destroy()}} will use the
\emph{latest} version of each target data object.
\item Optional: to back up the local metadata file with the version IDs
deleted, use \code{\link[=tar_meta_upload]{tar_meta_upload()}}.
}
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
ls() # Does not have "y1", "y2", or "z".
tar_load(starts_with("y"))
ls() # Has "y1" and "y2" but not "z".
tar_load(any_of("z"))
ls() # Has "y1", "y2", and "z".
})
}
}
\seealso{
Other data: 
\code{\link{tar_crew}()},
\code{\link{tar_load_everything}()},
\code{\link{tar_load_raw}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read}()},
\code{\link{tar_read_raw}()}
}
\concept{data}
