% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_sitrep.R
\name{tar_sitrep}
\alias{tar_sitrep}
\title{Show the cue-by-cue status of each target.}
\usage{
tar_sitrep(
  names = NULL,
  fields = NULL,
  reporter = "silent",
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function, reporter)
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_sitrep()}
only returns metadata on these targets.
You can supply symbols, a character vector,
or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{fields}{Optional, names of columns/fields to select. If supplied,
\code{tar_sitrep()} only returns the selected metadata columns.
You can supply symbols, a character vector, or \code{tidyselect} helpers
like \code{\link[=starts_with]{starts_with()}}. The \code{name} column is always included first
no matter what you select. Choices:
\itemize{
\item \code{name}: name of the target or global object.
\item \code{record}: Whether the \code{record} cue is activated:
\code{TRUE} if the target is not in the metadata (\code{\link[=tar_meta]{tar_meta()}}),
or if the target errored during the last \code{\link[=tar_make]{tar_make()}},
or if the class of the target changed.
\item \code{always}: Whether \code{mode} in \code{\link[=tar_cue]{tar_cue()}} is \code{"always"}.
If \code{TRUE}, \code{\link[=tar_make]{tar_make()}} always runs the target.
\item \code{never}: Whether \code{mode} in \code{\link[=tar_cue]{tar_cue()}} is \code{"never"}.
If \code{TRUE}, \code{\link[=tar_make]{tar_make()}} will only run if the
\code{record} cue activates.
\item \code{command}: Whether the target's command changed since last time.
Always \code{TRUE} if the \code{record} cue is activated.
Otherwise, always \code{FALSE} if the \code{command} cue is suppressed.
\item \code{depend}: Whether the data/output of at least one of the target's
dependencies changed since last time.
Dependencies are targets, functions,
and global objects directly upstream.
Call \code{tar_outdated(targets_only = FALSE)} or
\code{tar_visnetwork(targets_only = FALSE)} to see exactly which
dependencies are outdated.
Always \code{NA} if the \code{record} cue is activated.
Otherwise, always \code{FALSE} if the \code{depend} cue is suppressed.
\item \code{format}: Whether the storage format of the target
is different from last time.
Always \code{NA} if the \code{record} cue is activated.
Otherwise, always \code{FALSE} if the \code{format} cue is suppressed.
\item \code{iteration}: Whether the iteration mode of the target
is different from last time.
Always \code{NA} if the \code{record} cue is activated.
Otherwise, always \code{FALSE} if the \code{iteration} cue is suppressed.
\item \code{file}: Whether the file(s) with the target's return value
are missing or different from last time.
Always \code{NA} if the \code{record} cue is activated.
Otherwise, always \code{FALSE} if the \code{file} cue is suppressed.
}}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A data frame with one row per target/object and one column
per cue. Each element is a logical to indicate whether the cue
is activated for the target.
See the \code{field} argument in this help file for details.
}
\description{
For each target, report which cues are activated.
Except for the \code{never} cue, the target will rerun in \code{\link[=tar_make]{tar_make()}}
if any cue is activated. The target is suppressed if the \code{never}
cue is \code{TRUE}. See \code{\link[=tar_cue]{tar_cue()}} for details.
}
\details{
Caveats:
\itemize{
\item \code{\link[=tar_cue]{tar_cue()}} allows you to change/suppress cues, so the return
value will depend on the settings you supply to \code{\link[=tar_cue]{tar_cue()}}.
\item If a pattern tries to branches over a target that does not exist
in storage, then the branches are omitted from the output.
\item \code{tar_sitrep()} is myopic. It only considers what happens to the
immediate target and its immediate upstream dependencies,
and it makes no attempt to propagate invalidation downstream.
}
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_sitrep()
tar_meta(starts_with("y_"))
})
}
}
\seealso{
Other inspect: 
\code{\link{tar_deps_raw}()},
\code{\link{tar_deps}()},
\code{\link{tar_glimpse}()},
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_validate}()},
\code{\link{tar_visnetwork}()}
}
\concept{inspect}
