% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_assert.R
\name{tar_assert}
\alias{tar_assert}
\alias{tar_assert_chr}
\alias{tar_assert_dbl}
\alias{tar_assert_df}
\alias{tar_assert_equal_lengths}
\alias{tar_assert_envir}
\alias{tar_assert_expr}
\alias{tar_assert_flag}
\alias{tar_assert_file}
\alias{tar_assert_function}
\alias{tar_assert_function_arguments}
\alias{tar_assert_ge}
\alias{tar_assert_identical}
\alias{tar_assert_in}
\alias{tar_assert_not_dirs}
\alias{tar_assert_not_dir}
\alias{tar_assert_not_in}
\alias{tar_assert_inherits}
\alias{tar_assert_int}
\alias{tar_assert_internet}
\alias{tar_assert_lang}
\alias{tar_assert_le}
\alias{tar_assert_list}
\alias{tar_assert_lgl}
\alias{tar_assert_name}
\alias{tar_assert_names}
\alias{tar_assert_nonempty}
\alias{tar_assert_not_expr}
\alias{tar_assert_nzchar}
\alias{tar_assert_package}
\alias{tar_assert_path}
\alias{tar_assert_match}
\alias{tar_assert_nonmissing}
\alias{tar_assert_positive}
\alias{tar_assert_scalar}
\alias{tar_assert_target}
\alias{tar_assert_target_list}
\alias{tar_assert_true}
\alias{tar_assert_unique}
\alias{tar_assert_unique_targets}
\title{Assertions}
\usage{
tar_assert_chr(x, msg = NULL)

tar_assert_dbl(x, msg = NULL)

tar_assert_df(x, msg = NULL)

tar_assert_equal_lengths(x, msg = NULL)

tar_assert_envir(x, msg = NULL)

tar_assert_expr(x, msg = NULL)

tar_assert_flag(x, choices, msg = NULL)

tar_assert_file(x)

tar_assert_function(x, msg = NULL)

tar_assert_function_arguments(x, args, msg = NULL)

tar_assert_ge(x, threshold, msg = NULL)

tar_assert_identical(x, y, msg = NULL)

tar_assert_in(x, choices, msg = NULL)

tar_assert_not_dirs(x, msg = NULL)

tar_assert_not_dir(x, msg = NULL)

tar_assert_not_in(x, choices, msg = NULL)

tar_assert_inherits(x, class, msg = NULL)

tar_assert_int(x, msg = NULL)

tar_assert_internet(msg = NULL)

tar_assert_lang(x, msg = NULL)

tar_assert_le(x, threshold, msg = NULL)

tar_assert_list(x, msg = NULL)

tar_assert_lgl(x, msg = NULL)

tar_assert_name(x)

tar_assert_names(x, msg = NULL)

tar_assert_nonempty(x, msg = NULL)

tar_assert_not_expr(x, msg = NULL)

tar_assert_nzchar(x, msg = NULL)

tar_assert_package(package)

tar_assert_path(path, msg = NULL)

tar_assert_match(x, pattern, msg = NULL)

tar_assert_nonmissing(x, msg = NULL)

tar_assert_positive(x, msg = NULL)

tar_assert_scalar(x, msg = NULL)

tar_assert_target(x, msg = NULL)

tar_assert_target_list(x)

tar_assert_true(x, msg = NULL)

tar_assert_unique(x, msg = NULL)

tar_assert_unique_targets(x)
}
\arguments{
\item{x}{R object, input to be validated. The kind of object depends on the
specific assertion function called.}

\item{msg}{Character of length 1, a message to be printed to the console
if \code{x} is invalid.}

\item{choices}{Character vector of choices of \code{x} for certain assertions.}

\item{args}{Character vector of expected function argument names.
Order matters.}

\item{threshold}{Numeric of length 1, lower/upper bound for
assertions like \code{tar_assert_le()}/\code{tar_assert_ge()}.}

\item{y}{R object, value to compare against \code{x}.}

\item{class}{Character vector of expected class names.}

\item{package}{Character of length 1, name of an R package.}

\item{path}{Character, file path.}

\item{pattern}{Character of length 1, a \code{grep} pattern for certain
assertions.}
}
\description{
These functions assert the correctness of user inputs
and generate custom error conditions as needed. Useful
for writing packages built on top of \code{targets}.
}
\examples{
tar_assert_chr("123")
try(tar_assert_chr(123))
}
\seealso{
Other utilities to extend targets: 
\code{\link{tar_condition}},
\code{\link{tar_dir}()},
\code{\link{tar_language}},
\code{\link{tar_test}()}
}
\concept{utilities to extend targets}
