% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_path.R
\name{tar_path}
\alias{tar_path}
\title{Identify the file path where a target will be stored.}
\usage{
tar_path(name = NULL, default = NA_character_)
}
\arguments{
\item{name}{Symbol, name of a target.
If \code{NULL}, \code{tar_path()} returns the path of the target currently running
in a pipeline.}

\item{default}{Character, value to return if \code{tar_path()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}
}
\value{
Character, file path to a hypothetical target.
}
\description{
Identify the file path where a target will be stored
after the target finishes running in the pipeline.
}
\details{
\code{tar_path(name = your_target)} just returns
\verb{_targets/objects/your_target}, the file path where \code{your_target}
will be saved unless \code{format} is equal to \code{"file"} or any of the
supported cloud-based storage formats. If you call \code{tar_path()}
with no arguments while target \code{x} is running, the \code{name}
argument defaults to the name of the target,
so \code{tar_path()} returns \verb{_targets/objects/x}.
}
\examples{
tar_path()
tar_path(your_target)
if (identical(Sys.getenv("TARGETS_LONG_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script(tar_target(returns_path, tar_path()))
tar_make()
tar_read(returns_path)
})
}
}
