% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_plots.R
\name{tadaa_plot_tukey}
\alias{tadaa_plot_tukey}
\title{Plot TukeyHSD Results as Errorbars}
\usage{
tadaa_plot_tukey(data, brewer_palette = "Set1")
}
\arguments{
\item{data}{The \link[broom:tidy]{broom::tidy}'d output of \link[stats:TukeyHSD]{stats::TukeyHSD}.}

\item{brewer_palette}{Optional: The name of the \code{RColorBrewer} palette to use,
defaults to \code{Set1}. Use \code{NULL} for no brewer palette.}
}
\value{
A \link{ggplot2} object.
}
\description{
This is a simple plotting template that takes the \link[broom:tidy]{broom::tidy}'d output of
\link[stats:TukeyHSD]{stats::TukeyHSD} or alternatively the \code{print = "df"} output
of \link{tadaa_pairwise_tukey} and plots it nicely with error bars.
}
\note{
The \code{alpha} of the error bars is set to \code{0.25} if the comparison
is not significant, and \code{1} otherwise. That's neat.
}
\examples{
tests <- tadaa_pairwise_tukey(data = ngo, deutsch, jahrgang, geschl, print = "df")
tadaa_plot_tukey(tests)
}
\seealso{
Other Tadaa-plot functions: \code{\link{tadaa_balance}},
  \code{\link{tadaa_int}}, \code{\link{tadaa_mean_ci}}
}
