% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_ErdosRenyExponential_MCMC.R
\name{sample_ERE}
\alias{sample_ERE}
\title{Sample from the ERE model with given row and column sums}
\usage{
sample_ERE(l, a, p, lambda, nsamples = 10000, thin = 1000, burnin = 10000)
}
\arguments{
\item{l}{vector of interbank libabilities}

\item{a}{vector of interbank assets}

\item{p}{probability of existence of a link (either a numerical
value or a matrix). A single numerical value is converted into a
matrix with 0s on the diagonal.}

\item{lambda}{instensity parameters - either a numerical value or a
matrix with positive entries)}

\item{nsamples}{Number of samples to return.}

\item{thin}{Frequency at which samples should be generated (default=1, every step)}

\item{burnin}{Number of initial steps to discard.}
}
\value{
List of simulation results
}
\description{
Samples from the Erdos Reny model with Exponential weights and
known marginals.  Runs a Gibbs sampler to do this. A starting
liabilities is generated via \code{\link{getfeasibleMatr}} before
\code{\link{steps_ERE}} is called.
}
\examples{
l <- c(1,2.5,3)
a <- c(0.7,2.7,3.1)
L <- sample_ERE(l,a,p=0.5,lambda=0.25,nsamples=5,thin=20,burnin=10)
L


}

