% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutexes.R
\name{lock}
\alias{lock}
\alias{unlock.shared,boost.mutex-method}
\alias{lock.shared}
\alias{unlock}
\alias{unlock.shared}
\title{Lock and Unlock a Mutex}
\usage{
lock(m, ...)

lock.shared(m, ...)

unlock(m, ...)

unlock.shared(m, ...)
}
\arguments{
\item{m}{a mutex.}

\item{...}{options associated with the mutex being used including
\code{block} which forces the mutex to return immediately after trying
to acquire a lock}
}
\value{
The function returns \code{TRUE} if the lock is successfully 
called and \code{FALSE} otherwise
}
\description{
The \code{lock} and \code{unlock} functions allow a user to
specify exclusive or shared access to a resource.
}
\details{
A call to \code{lock} gives exclusive access to a resource; no other
mutex may acquire a lock.  A call to to \code{lock.shared} allows other
mutexes to acquire a shared lock on the resource.  When shared lock is
called while a exclusive lock has been acquired, the shared lock will
block until the exclusive lock is release.  Likewise, if an exclusive lock
is called while a shared lock has been acquired, the exclusive lock will
block until the shared lock is released.
}
\examples{
m = boost.mutex()
lock(m)
# Some code that needs to be synchronized...
unlock(m)
}
