/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import haplotype.BasicSampleHapPairs;
import haplotype.HapPair;
import haplotype.HapPairs;
import java.util.List;
import vcf.Marker;
import vcf.Markers;

public final class BasicHapPairs
implements HapPairs {
    private final Markers markers;
    private final HapPair[] hapPairs;
    private final boolean reverseMarkers;
    private final int lastMarker;

    public BasicHapPairs(List<HapPair> list) {
        this(list, false);
    }

    public BasicHapPairs(List<HapPair> list, boolean bl) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpy()==true");
        }
        Markers markers = BasicSampleHapPairs.checkAndExtractMarkers(list);
        this.markers = bl ? markers.reverse() : markers;
        this.hapPairs = list.toArray(new HapPair[0]);
        this.reverseMarkers = bl;
        this.lastMarker = this.markers.nMarkers() - 1;
    }

    @Override
    public byte allele1(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        return this.hapPairs[n2].allele1(n);
    }

    @Override
    public byte allele2(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        return this.hapPairs[n2].allele2(n);
    }

    @Override
    public byte allele(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.hapPairs[n3].allele1(n);
        }
        return this.hapPairs[n3].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.hapPairs.length;
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.length;
    }

    @Override
    public int idIndex(int n) {
        return this.hapPairs[n].idIndex();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("BasicHapPairs: nHapPairs=");
        stringBuilder.append(this.nHapPairs());
        return stringBuilder.toString();
    }
}

