/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import vcf.Marker;
import vcf.VcfHeader;

public class VcfRecord {
    private final String vcfRecord;
    private final VcfHeader vcfHeader;
    private final Marker marker;
    private final String qual;
    private final String filter;
    private final String info;
    private final String format;
    private final String[] sampleData;
    private final double qualityScore;
    private final String[] failedFilters;
    private final boolean filtersApplied;
    private final String[] infoFields;
    private final String[] formatFields;
    private final String[][] sampleFormatFields;
    private final boolean hasGTFormat;
    private final byte[][] alleles;
    private final boolean[] isPhased;
    private final Map<String, Integer> formatMap;

    public static int gtIndex(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("a1<0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("a2<0: " + n2);
        }
        if (n < n2) {
            return n2 * (n2 + 1) / 2 + n;
        }
        return n * (n + 1) / 2 + n2;
    }

    public VcfRecord(String string, VcfHeader vcfHeader) {
        this.vcfRecord = string;
        if (vcfHeader == null) {
            throw new NullPointerException("vcfHeader==null");
        }
        String[] stringArray = VcfRecord.getAndCheckFields(vcfHeader, string);
        this.vcfHeader = vcfHeader;
        this.marker = new Marker(string);
        this.qualityScore = VcfRecord.fromPhred(this.quality(stringArray[5]));
        this.qual = stringArray[5];
        this.filter = stringArray[6];
        this.info = stringArray[7];
        this.format = stringArray.length > 8 ? stringArray[8] : "";
        this.filtersApplied = !stringArray[6].equals(".");
        this.failedFilters = this.failedFilters(stringArray[6]);
        this.infoFields = StringUtil.getFields(stringArray[7], ';');
        this.formatFields = stringArray.length > 8 ? this.formats(stringArray[8]) : new String[]{};
        this.formatMap = VcfRecord.formatToIndexMap(vcfHeader, string, this.formatFields);
        this.sampleData = Arrays.copyOfRange(stringArray, Math.min(stringArray.length, 9), stringArray.length);
        this.hasGTFormat = this.formatMap.containsKey("GT");
        int n = vcfHeader.samples().nSamples();
        this.alleles = new byte[2][n];
        this.isPhased = new boolean[n];
        this.sampleFormatFields = new String[n][this.formatFields.length];
        this.storePerSampleData(this.sampleData);
    }

    private static String[] getAndCheckFields(VcfHeader vcfHeader, String string) {
        Object[] objectArray = StringUtil.getFields(string, '\t');
        if (vcfHeader.nHeaderFields() != objectArray.length) {
            File file = vcfHeader.file();
            String string2 = "File source: " + (file != null ? file : "stdin or unknown");
            String string3 = "Header line has " + vcfHeader.nHeaderFields() + " fields, but data line has " + objectArray.length + " fields" + Const.nl + string2 + Const.nl + Arrays.toString(objectArray);
            throw new IllegalArgumentException(string3);
        }
        return objectArray;
    }

    public static boolean isAlphanumeric(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static double toPhred(double d) {
        return -10.0 * Math.log10(d);
    }

    public static double fromPhred(double d) {
        return Math.pow(10.0, -d / 10.0);
    }

    private double quality(String string) {
        if (string.equals(".")) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    private String[] failedFilters(String string) {
        String[] stringArray;
        if (string.isEmpty()) {
            String string2 = "missing FILTER field: " + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        if (string.equals(".") || string.equals("PASS")) {
            return new String[0];
        }
        for (String string3 : stringArray = StringUtil.getFields(string, ';')) {
            if (!string3.isEmpty()) continue;
            String string4 = "missing filter in filter list: " + string;
            throw new IllegalArgumentException(string4);
        }
        return stringArray;
    }

    private String[] formats(String string) {
        String[] stringArray;
        if (string.equals(".")) {
            return new String[0];
        }
        for (String string2 : stringArray = StringUtil.getFields(string, ':')) {
            if (!string2.isEmpty()) continue;
            String string3 = "missing format in format list: " + this.vcfRecord;
            throw new IllegalArgumentException(string3);
        }
        return stringArray;
    }

    private static Map<String, Integer> formatToIndexMap(VcfHeader vcfHeader, String string, String[] stringArray) {
        if (vcfHeader.samples().nSamples() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], i);
        }
        if (hashMap.containsKey("GT") && (Integer)hashMap.get("GT") != 0) {
            String string2 = "GT format is not first format: " + string;
            throw new IllegalArgumentException(string2);
        }
        return hashMap;
    }

    private void storePerSampleData(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.vcfHeader.filter(i)) continue;
            String[] stringArray2 = this.parseSampleField(stringArray, i);
            if (this.hasGTFormat) {
                String string = stringArray2[0];
                int n2 = this.separatorIndex(string);
                this.alleles[0][n] = this.allele(string.substring(0, n2));
                this.alleles[1][n] = this.allele(string.substring(n2 + 1));
                this.isPhased[n] = string.charAt(n2) == '|';
            } else {
                this.alleles[0][n] = -1;
                this.alleles[1][n] = -1;
                this.isPhased[n] = false;
            }
            this.sampleFormatFields[n++] = stringArray2;
        }
        assert (n == this.sampleFormatFields.length);
    }

    private String[] parseSampleField(String[] stringArray, int n) {
        String[] stringArray2;
        String string = stringArray[n];
        if (string.isEmpty()) {
            String string2 = "Missing data for sample " + this.vcfHeader.samples().id(n) + ": " + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        if (string.equals(".")) {
            Object[] objectArray = new String[this.formatFields.length];
            Arrays.fill(objectArray, ".");
            if (this.hasGTFormat) {
                objectArray[0] = "./.";
            }
            return objectArray;
        }
        String[] object = stringArray2 = StringUtil.getFields(string, ':');
        int n2 = object.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = object[i];
            if (!string2.isEmpty()) continue;
            String string3 = "empty sub-field for sample " + this.vcfHeader.samples().id(n) + ": " + string;
            throw new IllegalArgumentException(string3);
        }
        if (stringArray2.length < this.formatFields.length) {
            String[] stringArray3 = Arrays.copyOf(stringArray2, this.formatFields.length);
            for (n2 = stringArray2.length; n2 < stringArray3.length; ++n2) {
                stringArray3[n2] = ".";
            }
            stringArray2 = stringArray3;
        }
        if (stringArray2.length > this.formatFields.length) {
            String string4 = "Expected at most " + this.formatFields.length + " sub-fields for sample " + this.vcfHeader.samples().id(n) + ": " + this.vcfRecord;
            throw new IllegalArgumentException(string4);
        }
        return stringArray2;
    }

    private int separatorIndex(String string) {
        int n = string.indexOf(47);
        if (n == -1 && (n = string.indexOf(124)) == -1) {
            String string2 = "missing genotype separator (" + string + "): " + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        return n;
    }

    private byte allele(String string) {
        if (string.isEmpty()) {
            String string2 = "Missing a sample allele: " + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        if (string.equals(".")) {
            return -1;
        }
        int n = Integer.parseInt(string);
        if (n < 0) {
            String string3 = "allele cannot be negative (" + n + "): " + this.vcfRecord;
            throw new IllegalArgumentException(string3);
        }
        if (n >= this.marker.nAlleles()) {
            String string4 = "allele " + n + " is not defined: " + this.vcfRecord;
            throw new IllegalArgumentException(string4);
        }
        if (n > 127) {
            String string5 = "Marker cannot have more than 127 alternate alleles: " + this.vcfRecord;
            throw new IllegalArgumentException(string5);
        }
        return (byte)n;
    }

    public String qual() {
        return this.qual;
    }

    public double qualityScore() {
        return this.qualityScore;
    }

    public boolean filtersApplied() {
        return this.filtersApplied;
    }

    public String filter() {
        return this.filter;
    }

    public int nFailedFilters() {
        return this.failedFilters.length;
    }

    public String failedFilters(int n) {
        return this.failedFilters[n];
    }

    public String info() {
        return this.info;
    }

    public int nInfoFields() {
        return this.infoFields.length;
    }

    public String infoField(int n) {
        return this.infoFields[n];
    }

    public String format() {
        return this.format;
    }

    public int nFormatFields() {
        return this.formatFields.length;
    }

    public String formatField(int n) {
        if (this.formatFields == null) {
            throw new IllegalArgumentException("No format exists");
        }
        return this.formatFields[n];
    }

    public boolean hasFormat(String string) {
        return this.formatMap.get(string) != null;
    }

    public int formatIndex(String string) {
        Integer n = this.formatMap.get(string);
        return n == null ? -1 : n;
    }

    public byte gt(int n, int n2) {
        return this.alleles[n2][n];
    }

    public boolean isPhased(int n) {
        return this.isPhased[n];
    }

    public String sampleData(int n) {
        return this.sampleData[n];
    }

    public String sampleFormatData(String string, int n) {
        Integer n2 = this.formatMap.get(string);
        if (n2 == null) {
            String string2 = "missing format data: " + string;
            throw new IllegalArgumentException(string2);
        }
        return this.sampleFormatFields[n][n2];
    }

    public String sampleFormatData(int n, int n2) {
        return this.sampleFormatFields[n2][n];
    }

    public String[] formatData(String string) {
        Integer n = this.formatMap.get(string);
        if (n == null) {
            String string2 = "missing format data: " + string;
            throw new IllegalArgumentException(string2);
        }
        return this.formatData(n);
    }

    public String[] formatData(int n) {
        String[] stringArray = new String[this.sampleFormatFields.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.sampleFormatFields[i][n];
        }
        return stringArray;
    }

    public Samples samples() {
        return this.vcfHeader.samples();
    }

    public int nSamples() {
        return this.vcfHeader.samples().nSamples();
    }

    public VcfHeader vcfHeader() {
        return this.vcfHeader;
    }

    public Marker marker() {
        return this.marker;
    }

    public String toString() {
        return this.vcfRecord;
    }
}

