/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.HapNodes;
import vcf.AL;

public class HapBaumLevel {
    private static final int INITIAL_CAPACITY = 100;
    private static final double MIN_VALUE = 4.94E-322;
    private final Dag dag;
    private final AL al;
    private int marker = -1;
    private int hap = -1;
    private int size = 0;
    private int capacity = 100;
    private int[] edges = new int[100];
    private double[] fwdValues = new double[100];
    private double[] bwdValues = new double[100];
    private double fwdValueSum = 0.0;
    private double bwdValueSum = 0.0;
    private int nAlleles = 0;
    private double[] alProbs = new double[3];

    public HapBaumLevel(Dag dag, AL aL) {
        if (!dag.markers().equals(aL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.al = aL;
    }

    public static void initializeNodes(HapNodes hapNodes) {
        hapNodes.clear();
        hapNodes.sumUpdate(0, 1.0);
    }

    public void setForwardValues(HapNodes hapNodes, int n, int n2) {
        this.marker = n;
        this.hap = n2;
        this.nAlleles = this.al.marker(n).nAlleles();
        this.size = 0;
        this.fwdValueSum = 0.0;
        this.bwdValueSum = 0.0;
        this.setStates(hapNodes);
        this.setChildNodes(hapNodes);
    }

    private void setStates(HapNodes hapNodes) {
        int n;
        double d = 0.0;
        int n2 = hapNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = hapNodes.enumNode(n);
            int n4 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n4; ++i) {
                int n5 = this.dag.outEdge(this.marker, n3, i);
                byte by = this.dag.symbol(this.marker, n5);
                float f = this.al.al(this.marker, this.hap, by);
                if (!(f > 0.0f)) continue;
                if (this.size == this.capacity) {
                    this.ensureCapacity(this.size + 1);
                }
                this.edges[this.size] = n5;
                double d2 = this.dag.condEdgeProb(this.marker, n5);
                double d3 = (double)f * hapNodes.enumValue(n) * d2;
                if (d3 < 4.94E-322) {
                    assert (hapNodes.enumValue(n) > 0.0);
                    d3 = 4.94E-322;
                }
                this.fwdValues[this.size++] = d3;
                d += d3;
            }
        }
        assert (d > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n6 = n++;
            this.fwdValues[n6] = this.fwdValues[n6] / d;
        }
        this.fwdValueSum = d;
    }

    public void setChildNodes(HapNodes hapNodes) {
        hapNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges[i]);
            hapNodes.sumUpdate(n, this.fwdValues[i]);
        }
    }

    public void setInitialBackwardValues(HapNodes hapNodes) {
        hapNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges[i]);
            hapNodes.maxUpdate(n, 1.0);
        }
        this.setBackwardValues(hapNodes);
    }

    public void setBackwardValues(HapNodes hapNodes) {
        int n;
        int n2;
        this.bwdValueSum = 0.0;
        if (this.alProbs.length < this.nAlleles) {
            int n3 = Math.max(this.nAlleles, 3 * this.alProbs.length / 2 + 1);
            this.alProbs = new double[n3];
        }
        Arrays.fill(this.alProbs, 0, this.nAlleles, 0.0);
        double d = 0.0;
        for (n2 = 0; n2 < this.size; ++n2) {
            double d2;
            n = this.dag.childNode(this.marker, this.edges[n2]);
            this.bwdValues[n2] = d2 = hapNodes.value(n);
            this.bwdValueSum += d2;
        }
        hapNodes.clear();
        for (n2 = 0; n2 < this.size; ++n2) {
            int n4 = n2;
            this.bwdValues[n4] = this.bwdValues[n4] / this.bwdValueSum;
            n = this.edges[n2];
            byte by = this.symbol(n2);
            int n5 = this.dag.parentNode(this.marker, n);
            double d3 = this.dag.condEdgeProb(this.marker, n);
            double d4 = this.fwdValues[n2] * this.bwdValues[n2];
            byte by2 = by;
            this.alProbs[by2] = this.alProbs[by2] + d4;
            d += d4;
            double d5 = this.bwdValues[n2] * d3 * (double)this.al.al(this.marker, this.hap, by);
            if (d5 < 4.94E-322 && this.bwdValues[n2] > 0.0) {
                d5 = 4.94E-322;
            }
            hapNodes.sumUpdate(n5, d5);
        }
        n2 = 0;
        while (n2 < this.nAlleles) {
            int n6 = n2++;
            this.alProbs[n6] = this.alProbs[n6] / d;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public AL emissions() {
        return this.al;
    }

    public int marker() {
        return this.marker;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public double alProbs(int n) {
        if (n >= this.nAlleles) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.alProbs[n];
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edge(int n) {
        this.checkIndex(n);
        return this.edges[n];
    }

    public int parentNode(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges[n]);
    }

    public int childNode(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges[n]);
    }

    public byte symbol(int n) {
        return this.dag.symbol(this.marker, this.edge(n));
    }

    public double forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public double backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public double forwardValuesSum() {
        return this.fwdValueSum;
    }

    public double backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edge(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edges = Arrays.copyOf(this.edges, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

