/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class SingleNodes {
    private static final double loadFactor = 0.75;
    private int[] index;
    private int[] node1;
    private int[] node2;
    private double[] value;
    private int size = 0;
    private int maxSize = 1024;
    private int rehashThreshold = (int)(0.75 * (double)this.maxSize);

    public SingleNodes() {
        this.index = new int[this.maxSize];
        this.node1 = new int[this.maxSize];
        this.node2 = new int[this.maxSize];
        this.value = new double[this.maxSize];
    }

    private static int hash1(int n, int n2) {
        int n3 = 5;
        n3 = 71 * n3 + n;
        n3 = 71 * n3 + n2;
        return n3;
    }

    private static int hash2(int n, int n2) {
        int n3 = 7;
        n3 = 97 * n3 + n;
        n3 = 97 * n3 + n2;
        return n3;
    }

    private int index(int n, int n2) {
        int n3 = SingleNodes.hash1(n, n2);
        int n4 = SingleNodes.hash2(n, n2);
        if ((n4 & 1) == 0) {
            ++n4;
        }
        for (int i = 0; i < this.maxSize; ++i) {
            int n5 = (n3 + i * n4) % this.maxSize;
            if (n5 < 0) {
                n5 = -n5;
            }
            if (this.value[n5] != 0.0 && (this.node1[n5] != n || this.node2[n5] != n2)) continue;
            return n5;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.maxSize;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.node1;
        int[] nArray3 = this.node2;
        double[] dArray = this.value;
        this.maxSize = n;
        this.index = new int[n];
        this.node1 = new int[n];
        this.node2 = new int[n];
        this.value = new double[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3], nArray3[n3]);
            this.node1[n2] = nArray2[n3];
            this.node2[n2] = nArray3[n3];
            this.value[n2] = dArray[n3];
        }
        this.rehashThreshold = (int)(0.75 * (double)this.maxSize);
    }

    public void maxUpdate(int n, int n2, double d) {
        if (d > 0.0) {
            int n3 = this.index(n, n2);
            if (this.value[n3] > 0.0) {
                if (d > this.value[n3]) {
                    this.value[n3] = d;
                }
            } else {
                this.index[this.size++] = n3;
                this.node1[n3] = n;
                this.node2[n3] = n2;
                this.value[n3] = d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public void sumUpdate(int n, int n2, double d) {
        if (d > 0.0) {
            int n3 = this.index(n, n2);
            if (this.value[n3] > 0.0) {
                int n4 = n3;
                this.value[n4] = this.value[n4] + d;
            } else {
                this.index[this.size++] = n3;
                this.node1[n3] = n;
                this.node2[n3] = n2;
                int n5 = n3;
                this.value[n5] = this.value[n5] + d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int enumNode1(int n) {
        this.checkSize(n);
        return this.node1[this.index[n]];
    }

    public int enumNode2(int n) {
        this.checkSize(n);
        return this.node2[this.index[n]];
    }

    public double enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public double value(int n, int n2) {
        return this.value[this.index(n, n2)];
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": node1=");
            stringBuilder.append(this.enumNode1(i));
            stringBuilder.append(" node2=");
            stringBuilder.append(this.enumNode2(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

