/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import blbutil.Const;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import vcf.Marker;

public final class Markers {
    private final Set<Marker> markerSet;
    private final Marker[] fwdMarkers;
    private final int[] fwdSumAlleles;
    private final int[] fwdSumGenotypes;
    private final int[] fwdSumHaplotypeBits;
    private final int fwdHashCode;
    private final Marker[] bwdMarkers;
    private final int[] bwdSumAlleles;
    private final int[] bwdSumGenotypes;
    private final int[] bwdSumHaplotypeBits;
    private final int bwdHashCode;

    public Markers(Marker[] markerArray) {
        Markers.checkMarkerPosOrder(markerArray);
        this.fwdMarkers = (Marker[])markerArray.clone();
        this.bwdMarkers = Markers.reverse(this.fwdMarkers);
        this.markerSet = Markers.markerSet(this.fwdMarkers);
        this.fwdSumAlleles = Markers.cumSumAlleles(this.fwdMarkers);
        this.fwdSumGenotypes = Markers.cumSumGenotypes(this.fwdMarkers);
        this.fwdSumHaplotypeBits = Markers.cumSumHaplotypeBits(this.fwdMarkers);
        this.fwdHashCode = Arrays.deepHashCode(this.fwdMarkers);
        this.bwdSumAlleles = Markers.cumSumAlleles(this.bwdMarkers);
        this.bwdSumGenotypes = Markers.cumSumGenotypes(this.bwdMarkers);
        this.bwdSumHaplotypeBits = Markers.cumSumHaplotypeBits(this.bwdMarkers);
        this.bwdHashCode = Arrays.deepHashCode(this.bwdMarkers);
    }

    private Markers(Markers markers) {
        this.markerSet = markers.markerSet;
        this.fwdMarkers = markers.bwdMarkers;
        this.bwdMarkers = markers.fwdMarkers;
        this.fwdSumAlleles = markers.bwdSumAlleles;
        this.fwdSumGenotypes = markers.bwdSumGenotypes;
        this.fwdSumHaplotypeBits = markers.bwdSumHaplotypeBits;
        this.fwdHashCode = markers.bwdHashCode;
        this.bwdSumAlleles = markers.fwdSumAlleles;
        this.bwdSumGenotypes = markers.fwdSumGenotypes;
        this.bwdSumHaplotypeBits = markers.fwdSumHaplotypeBits;
        this.bwdHashCode = markers.fwdHashCode;
    }

    private static void checkMarkerPosOrder(Marker[] markerArray) {
        if (markerArray.length < 2) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(markerArray[0].chromIndex());
        hashSet.add(markerArray[1].chromIndex());
        for (int i = 2; i < markerArray.length; ++i) {
            int n = markerArray[i - 2].chromIndex();
            int n2 = markerArray[i - 1].chromIndex();
            int n3 = markerArray[i].chromIndex();
            if (n == n2 && n2 == n3) {
                int n4 = markerArray[i - 2].pos();
                int n5 = markerArray[i - 1].pos();
                int n6 = markerArray[i].pos();
                if ((n5 >= n4 || n5 >= n6) && (n5 <= n4 || n5 <= n6)) continue;
                String string = "markers not in chromosomal order: " + Const.nl + markerArray[i - 2] + Const.nl + markerArray[i - 1] + Const.nl + markerArray[i];
                throw new IllegalArgumentException(string);
            }
            if (n2 == n3) continue;
            if (hashSet.contains(n3)) {
                String string = "markers on chromosome are not contiguous: " + ChromIds.instance().id(n3);
                throw new IllegalArgumentException(string);
            }
            hashSet.add(n3);
        }
    }

    private static Marker[] reverse(Marker[] markerArray) {
        int n = markerArray.length - 1;
        Marker[] markerArray2 = new Marker[markerArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray2[i] = markerArray[n - i];
        }
        return markerArray2;
    }

    private static Set<Marker> markerSet(Marker[] markerArray) {
        HashSet<Marker> hashSet = new HashSet<Marker>(markerArray.length);
        for (Marker marker : markerArray) {
            if (hashSet.add(marker)) continue;
            throw new IllegalArgumentException("Duplicate marker: " + marker);
        }
        return hashSet;
    }

    private static int[] cumSumAlleles(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + markerArray[i - 1].nAlleles();
        }
        return nArray;
    }

    private static int[] cumSumGenotypes(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + markerArray[i - 1].nGenotypes();
        }
        return nArray;
    }

    private static int[] cumSumHaplotypeBits(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            int n = markerArray[i - 1].nAlleles() - 1;
            int n2 = 32 - Integer.numberOfLeadingZeros(n);
            nArray[i] = nArray[i - 1] + n2;
        }
        return nArray;
    }

    public int hashCode() {
        return this.fwdHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Markers markers = (Markers)object;
        return Arrays.deepEquals(this.fwdMarkers, markers.fwdMarkers);
    }

    public Markers reverse() {
        return new Markers(this);
    }

    public int nMarkers() {
        return this.fwdMarkers.length;
    }

    public Marker marker(int n) {
        return this.fwdMarkers[n];
    }

    public Marker[] markers() {
        return (Marker[])this.fwdMarkers.clone();
    }

    public boolean contains(Marker marker) {
        return this.markerSet.contains(marker);
    }

    public Markers restrict(int n, int n2) {
        if (n2 > this.fwdMarkers.length) {
            throw new IndexOutOfBoundsException("end > this.nMarkers(): " + n2);
        }
        return new Markers(Arrays.copyOfRange(this.fwdMarkers, n, n2));
    }

    public int sumAlleles(int n) {
        return this.fwdSumAlleles[n];
    }

    public int sumAlleles() {
        return this.fwdSumAlleles[this.fwdMarkers.length];
    }

    public int sumGenotypes(int n) {
        return this.fwdSumGenotypes[n];
    }

    public int sumGenotypes() {
        return this.fwdSumGenotypes[this.fwdMarkers.length];
    }

    public int sumHaplotypeBits(int n) {
        return this.fwdSumHaplotypeBits[n];
    }

    public int sumHaplotypeBits() {
        return this.fwdSumHaplotypeBits[this.fwdMarkers.length];
    }

    public String toString() {
        return Arrays.toString(this.fwdMarkers);
    }
}

