#' Data on the performance of different symptom checkers
#'
#' Dataset generated by Schmieding et al. that tested different symptom checkers with 45 vignettes in 2020. It includes the solution to the case vignettes and the advice each symptom checker gave.
#'
#' @docType data
#'
#' @usage data(symptomcheckRdata)
#'
#' @format An object of class \code{"data.frame"}
#' \describe{
#'  \item{App_name}{The name of the app used in this evaluation)}
#'  \item{Vignette_id}{An identificator referencing the number of each vignette (same numbers indicate the same vignettes)}
#'  \item{Triage_advice_from_app}{The triage advice the app recommended for this case (Emergency, Non-Emergency or Self-care)}
#'  \item{Goldstandard_solution}{The goldstandard solution for this vignette}
#'  \item{Correct_Triage_Advice_provided_from_app}{A Boolean whether the app provided the correct advice)}
#' }
#' @references This data set was created by Schmieding et al.: https://doi.org/10.5281/zenodo.6054092
#' @keywords symptom-checker
#' @examples
#'
#' data(symptomcheckRdata)
#' head(symptomcheckRdata)
#'
"symptomcheckRdata"
