\name{svyPVquantile}
\alias{svyPVquantile}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Quantile estimation
}
\description{
This function estimates quantiles of plausible values within groups.
}
\usage{
svyPVquantile(by, svydat, pvs, quantile, interval.type = "quantile", colN=FALSE, ...)
}

\arguments{
  \item{by}{
A formula statement is expected which splits the data into several subsets. Within these subsets the quantiles are estimated.
}
  \item{svydat}{
A survey design (\code{svydesign} as well as \code{svrepdesign}) which was generated by the \code{survey} package. To figure out how to create a survey design object, please read the help files for the \code{survey} package.
}
  \item{pvs}{
A character vector which includes the colnames of the plausible values. These variables must be part of the survey design comitted as \code{svydat}.
}
  \item{quantile}{
A numeric vector of length > 1 which contains the quantiles of interest.
}
  \item{interval.type}{
A character vector of length = 1 which denotes the kind of quantile estimation method. Valid inputs are: "quantile" and "probability" if a svrepdesign was submitted and in case of a oridinary survey design the valid inputs are: "Wald", "score" and "betaWald". More information about the different estimation techniques can be gained from the "Details" section of the \code{svyquantile} function in the \code{survey} package.
}

  \item{\dots}{
More arguments which are forwarded to \code{svyquantile}.
}


  \item{colN}{
If TRUE the colnames will equal the grouping variable names from the by statement. If FALSE, which is the default, the names will be Group1 up to Group k.}

}


\value{
The function returns a data.frame with the following columns
\item{Group1..k}{The first k columns show the different levels of the k subsetting groups.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
\item{q0...}{These columns contain the quantile values which were estimated by means of the submitted plausible values.}
}


\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}
\author{
Manuel Reif
}

\seealso{
\code{\link{svyPVpm}}
}

\examples{
data(svy_example1)

erg_q <- svyPVquantile(by = ~ sex, svydat=svy.exrep,
pvs=c("plaus1","plaus2","plaus3"), quantile=c(0.2,0.7))

erg_q
}


\keyword{quantile}
