\name{svyPVpm}
\alias{svyPVpm}

\title{
Mean and proportion estimation
}
\description{
This function estimates mean, standard deviation and proportion of subsets based on a survey design and plausible values.
}
\usage{
svyPVpm(by, svydat, pvs, colN=FALSE)
}

\arguments{
  \item{by}{
A formula statement is expected which splits the data into several subsets. Means and proportions will be estimated within these subsets. 
}
  \item{svydat}{
A survey design which was generated by the \code{survey} package.
}
  \item{pvs}{
A character vector which includes the colnames of the plausible values. These variables must be part of the survey design comitted as \code{svydat}. 
}

  \item{colN}{
If TRUE the colnames will equal the grouping variable names from the by statement. If FALSE, which is the default, the names will be Group1 up to Group k.}

}

\details{

All variables, including the subsetting ones defined with \code{by}, must be part of the survey design object.

Missing values are deleted listwise.

Note that '.' is not allowed as part of the level string of a \code{by} variable. For example c("1.thing","2.thing") is not allowed and will cause a error message. 
}


\value{
The function returns a data.frame with the following columns
\item{Group1..k}{The first k columns show the different levels of the k subsetting groups.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
\item{Proportion}{Shows the (weighted) estimated proportion of persons within the categories.}
\item{Proportion.SE}{Shows the Standard Errors of the proportion estimate.}
\item{pvs_mean}{Shows the mean estimate of plausible values within each group.}
\item{pvs_mean.SE}{Denotes the Standard error of the mean estimate.}
\item{pvs_stddev}{Shows the standard deviation (sd) estimate of plausible values within each group.}
\item{pvs_stddev.SE}{Denotes the Standard error of the sd estimate.}
}


\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}

\author{
Manuel Reif
}


\seealso{
\code{\link{svyPVglm}}
\code{\link{svyPVprob}}
}

\examples{

data(svy_example1)

erg_pm <- svyPVpm(by = ~ sex, svydat=svy.exrep, pvs=c("plaus1","plaus2","plaus3"))

erg_pm

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Mean}
\keyword{proportion}
