% Generated by roxygen2 (4.0.1): do not edit by hand
\name{COV}
\alias{COV}
\alias{COV.numeric}
\alias{COV.stratTen}
\alias{COV.ten}
\title{\bold{cov}ariance matrix for survival data}
\usage{
COV(x, ...)

\method{COV}{ten}(x, ..., reCalc = FALSE)

\method{COV}{stratTen}(x, ..., reCalc = FALSE)

\method{COV}{numeric}(x, ..., n, ncg)
}
\arguments{
\item{x}{A \code{numeric} vector of
\emph{number of events}, \eqn{e_t}{e[t]}.
These are assumed to be ordered by discrete times.
\cr
A method is available for objects of \code{class} \code{ten}.}

\item{...}{Additional arguments (not implemented).}

\item{reCalc}{Recalcuate the values?
 \cr
If \code{reCalc=FALSE} (the default) and the \code{ten} object already has
the calculated values stored as an \code{attribute},
the value of the \code{attribute} is returned directly.
 \cr \cr
\bold{--Arguments for the numeric method:}}

\item{n}{\bold{n}umber at risk (total).}

\item{ncg}{\bold{n}umber at risk, per \bold{c}ovariate \bold{g}roup.
 \cr
If there are \eqn{2} groups, this can be given as a \code{vector} with
the number at risk for group \eqn{1}.
\cr
If there are \eqn{\geq 2}{>= 2} groups, it is
a \code{matrix} with one column for each group.}
}
\value{
An \code{array}.
\cr
The first two dimensions = the number of covariate groups \eqn{K},
\eqn{k = 1, 2, \ldots K}.
This is the square matrix below.
\cr
The third dimension is the number of observations
(discrete time points).
\cr \cr
To calculate this, we use \code{x} (= \eqn{e_t}{e[t]} below) and
\eqn{n_1}{n1}, the number at risk in covariate group \eqn{1}.
\cr
Where there are \eqn{2} groups, the resulting sparse square matrix
(i.e. the non-diagonal elements are \eqn{0})
at time \eqn{t} has diagonal elements:
 \deqn{cov_t = - \frac{n_{0t} n_{1t} e_t (n_t - e_t)}{n_t^2(n_t-1)}}{
       cov[t] = - n0[t] * n1[t] * e[t] * (n[t] - e[t]) /
                 (n[t]^2 * (n[t] - 1))}
For \eqn{\geq 2}{>=2} groups, the resulting square matrix
has diagonal elements given by:
 \deqn{cov_{kkt} = \frac{n_{kt}(n_t - n_{kt}) e_t(n_t - e_t)}{
                         n_t^2(n_t - 1)}}{
   cov[k, k, t] = n[k, t] * (n[t] - n[k, t]) * e[t] * (n[t] - e[t]) /
                  (n[t]^2 * (n[t] - 1))}
The off diagonal elements are:
\deqn{cov_{klt} = \frac{-n_{kt} n_{lt} e_t (n_t-e_t) }{
                        n_t^2(n_t-1)}}{
      cov[k, l, t] = - n[k, t] * n[l, t] * e[t] * (n[t] - e[t]) /
                     n[t]^2 * (n[t] - 1)}
}
\description{
\bold{cov}ariance matrix for survival data


}
\details{
Gives variance-covariance matrix for comparing survival
data for two or more groups.
\cr
Inputs are vectors corresponding to observations at a set of discrete
time points for right censored data, except for \eqn{n1},
the no. at risk by predictor.
\cr
This should be specified as a vector for one group,
otherwise as a matrix with each column corresponding to a group.
}
\note{
Where the is just one subject at risk \eqn{n=1} at
the final timepoint, the equations above may produce \code{NaN}
due to division by zero. This is converted to \code{0} for
simplicity.
}
\examples{
## Two covariate groups
## K&M. Example 7.2, pg 210, table 7.2 (last column).
data("kidney", package="KMsurv")
k1 <- with(kidney,
           ten(Surv(time=time, event=delta) ~ type))
COV(k1)[COV(k1) > 0]
## Four covariate groups
## K&M. Example 7.6, pg 217.
data("larynx", package="KMsurv")
l1 <- ten(Surv(time, delta) ~ stage, data=larynx)
rowSums(COV(l1), dims=2)
## example of numeric method
## Three covariate groups
## K&M. Example 7.4, pg 212.
data("bmt", package="KMsurv")
b1 <- asWide(ten(Surv(time=t2, event=d3) ~ group, data=bmt))
rowSums(b1[, COV(x=e, n=n, ncg=matrix(data=c(n_1, n_2, n_3), ncol=3))], dims=2)
}
\seealso{
Called by \code{\link{comp}}

The name of the function is capitalized
to distinguish it from:
 \cr
?stats::cov
}
\keyword{survival}

