% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{tneBMT}
\alias{tneBMT}
\title{Time, no. at risk, no. events for BMT data}
\format{A \code{data.frame} with \eqn{76} rows and \eqn{9} columns.}
\source{
Generated from \code{data("bmt", package="KMsurv")}.
\itemize{
  \item Time (\code{bmt$t2}) is disease free survival time.
  \item Event (\code{bmt$d3}) is death or relapse.
}

Klein J, Moeschberger 2003
\emph{Survival Analysis}, 2nd edition.
New York: Springer.
Example 7.9, pg 224.
}
\description{
Time, no. at risk, no. events for BMT data
}
\details{
Data on survival time following bone-marrow transplant.
\cr \cr
Columns are:
\describe{
  \item{t}{time}
  \item{n_1}{no. at risk in group 1 (ALL)}
  \item{e_1}{no. events in group 1}
  \item{n_2}{no. at risk in group 2 (AML low-risk)}
  \item{e_2}{no. events in group 2}
  \item{n_3}{no. at risk in group 3 (AML high-risk)}
  \item{e_3}{no. events in group 3}
  \item{n}{no. at risk overall}
  \item{e}{no. events overall}
}
}
\references{
Copelan EA, Biggs JC, Thompson JM, Crilley P, Szer J, Klein JP, Kapoor N,
Avalos BR, Cunningham I, Atkinson K, et al 1991
Treatment for acute myelocytic leukemia with allogeneic bone marrow transplantation
following preparation with BuCy2.
\emph{Blood}. \bold{78}(3):838-43.
\href{http://bloodjournal.hematologylibrary.org/content/78/3/838.full.pdf}{Blood}
}
\seealso{
\code{?KMsurv::bmt}
\cr
\code{\link{comp}}
}

