% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratbr.R
\name{stratbr}
\alias{stratbr}
\title{Optimization Algorithm to solve stratification problem}
\usage{
stratbr(X, H = 3, n = 30, nmin = 2, takeall = FALSE, tampop = 100,
  totgen = 1500, pelite = 0.2, pmutant = 0.3, rc = 0.6, cores = 2)
}
\arguments{
\item{X}{Stratification variable.}

\item{H}{Number of strata.}

\item{n}{Sample size.}

\item{nmin}{Minimum sample size (smallest possible sample size in any stratum).}

\item{takeall}{Take-all stratum (takeall=TRUE) =>  nH=NH.}

\item{tampop}{Number of chromosomes BRKGA.}

\item{totgen}{Number of generations BRKGA.}

\item{pelite}{Percentage elite solutions BRKGA.}

\item{pmutant}{Percentage mutant solutions BRKGA.}

\item{rc}{Crossover probability  BRKGA.}

\item{cores}{Numerical amount of CPUs requested for the cluster.}
}
\value{
\item{cvtot}{Coefficient of variation for the estimator of total of the stratification variable considered.}

\item{nh}{Number of sample elements, or sample size, in stratum h.}

\item{Nh}{Number of population elements, or population size, in stratum h.}

\item{Sh2}{Population variance of the stratification variable x in stratum h.}

\item{bk}{Strata boundaries}

\item{cputime}{Time consumed by the algorithm in seconds.}
}
\description{
This function aims at constructing optimal strata with an optimization algorithm
based on a global optimisation technique called Biased Random Key Genetic Algorithms(BRKGA).
The optimization algorithm is applied to solve the one dimensional case,
which reduces the stratification problem to just determining strata boundaries.
Assuming that the number H of strata and the total sample size n are fixed,
it is possible to produce the strata boundaries by taking into consideration
an objective function associated with the variance.
This function determines strata boundaries so that the elements in each
stratum are more homogeneous among themselves.
}
\examples{
data(Sweden)
REV84<-Sweden[,9]
solution1<-stratbr(REV84,H=3,n=50,nmin=10,totgen=2,cores=4)
data(USbanks)
solution2<-stratbr(USbanks,H=3,n=50,totgen=2,cores=4,takeall=TRUE)
}
\references{
Brito, J.A.M, Silva, P.L.N.,Semaan, G.S. and Maculan, N. (2015).
           Integer Programming Formulations Applied to Optimal Allocation in Stratified Sampling.
           Survey Methodology, 41: 427-442.

           Brito, J.A.M, Semaan, G.S., Fadel, A.C. and Brito, L.R.(2017).
           An optimization approach applied to the optimal stratification problem,
           Communications in Statistics - Simulation and Computation.

           Gonçalves, J.R. and Resende, M.G.C. (2011).
           Biased random-key genetic algorithms for combinatorial optimization,
           Journal of Heuristics, 17: 487-525.
}
\author{
Jose Brito (jambrito@gmail.com), Pedro Luis and Tomas Veiga.
}
