% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratbr.R
\name{stratbr}
\alias{stratbr}
\title{Optimization Algorithm to solve stratification problem}
\usage{
stratbr(X, stratas = 3, nsample = 30, tampop = 100, totgen = 1500,
  pelite = 0.2, pmutant = 0.3, rc = 0.6, minimumsample = 2, cores = 2)
}
\arguments{
\item{X}{Stratification variable.}

\item{stratas}{Number of strata.}

\item{nsample}{Sample size.}

\item{tampop}{Number of chromosomes BRKGA.}

\item{totgen}{Number of generations BRKGA.}

\item{pelite}{Percentage elite solutions BRKGA.}

\item{pmutant}{Percentage mutant solutions BRKGA.}

\item{rc}{Crossover probability  BRKGA.}

\item{minimumsample}{Minimum sample size (smallest possible sample size in any stratum).}

\item{cores}{Numerical amount of CPUs requested for the cluster.}
}
\value{
\item{cvtot}{Coefficient of variation for the estimator of total of the stratification variable considered.}

\item{nh}{Number of sample elements, or sample size, in stratum h.}

\item{Nh}{Number of population elements, or population size, in stratum h.}

\item{Sh2}{Population variance of the stratification variable x in stratum h.}

\item{bk}{Strata boundaries}

\item{cputime}{Time consumed by the algorithm in seconds.}
}
\description{
This function aims at constructing optimal strata with an optimization algorithm
based on a global optimisation technique called Biased Random Key Genetic Algorithms(BRKGA).
The optimization algorithm is applied to solve the onedimensional case,
which reduces the stratification problem to just determining strata boundaries.
Assuming that the number H of strata and the total sample size n are fixed,
it is possible to produce the strata boundaries by taking into consideration
an objective function associated with the variance.
This function determines strata boundaries so that the elements in each
stratum are more homogeneous among themselves.
}
\examples{
data(Sweden)
REV84<-Sweden[,9]
solution1<-stratbr(REV84,stratas=3,nsample=100,cores=4,totgen=20)
#'solution2<-stratbr(REV84,stratas=3,nsample=100,cores=4,totgen=20,minimumsample=30)
ME84<-Sweden[,8]
solution3<-stratbr(ME84,stratas=4,nsample=75,cores=2,totgen=20)
}
\author{
Jose Brito (jambrito@gmail.com), Pedro Luis and Tomas Veiga.
}
\references{
Brito, J.A.M, Silva, P.L.N.,Semaan, G.S. and Maculan, N. (2015).
           Integer Programming Formulations Applied to Optimal Allocation in Stratified Sampling.
           Survey Methodology, 41: 427-442.

           Brito, J.A.M, Semaan, G.S., Fadel, A.C. and Brito, L.R.(2017).
           An optimization approach applied to the optimal stratification problem,
           Communications in Statistics - Simulation and Computation.

           Gonçalves, J.R. and Resende, M.G.C. (2011).
           Biased random-key genetic algorithms for combinatorial optimization,
           Journal of Heuristics, 17: 487-525.
}

