% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haplotypeLikelihoods.R
\name{haplotypeLikelihoods}
\alias{haplotypeLikelihoods}
\title{Haplotype Likelihoods}
\usage{
haplotypeLikelihoods(x, model = "raw", pairwise.deletion = FALSE,
  plot.n = NULL, ...)
}
\arguments{
\item{x}{a \code{\link[ape]{DNAbin}} object.}

\item{model}{a character string specifying the evolutionary model to be 
used. Passed to \code{\link[ape]{dist.dna}}.}

\item{pairwise.deletion}{a logical indicating whether to delete the 
sites with missing data in a pairwise way. Passed to 
\code{\link[ape]{dist.dna}}.}

\item{plot.n}{number of haplotypes with lowest delta(log-likelihoods) to 
plot. Defaults to all haplotypes. Set to 0 to supress plotting.}

\item{...}{arguments passed from other functions (ignored).}
}
\value{
vector of delta(log-Likelihoods) for each haplotype, sorted from 
  smallest to largest, and a plot of their distributions.
}
\description{
Calculate likelihood of each haplotype based on gamma 
  distribution of pairwise distances.
}
\details{
Fits a Gamma distribution to the pairwise distances of haplotypes 
  and calculates the log-likelihood for each haplotype (sum of all pairwise 
  log-likelihoods for that haplotype). Haplotypes that are extremely 
  different from all others will have low log-likelihoods. Values returned 
  as delta(log-likelhoods) = difference of log-likelihoods from maximum 
  observed values.
}
\examples{
library(ape)
data(dolph.haps)

haplotypeLikelihoods(as.DNAbin(dolph.haps))

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

