% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedNumAlleles.R
\name{exptdNumAlleles}
\alias{exptdNumAlleles}
\title{Expected Number of Alleles}
\usage{
exptdNumAlleles(n, theta, ploidy)
}
\arguments{
\item{n}{size of sample.}

\item{theta}{value of theta in population (= 2 * \code{ploidy} * Ne * mu).}

\item{ploidy}{ploidy of locus.}
}
\value{
a two element vector with the expected number of alleles
  (\code{num.alleles}) and variance (\code{var.num.alleles}).
}
\description{
Calculate the expected number of alleles in a sample of a
  given size and value of theta.
}
\examples{

exptdNumAlleles(20, 1, 2)

# double the samples
exptdNumAlleles(40, 1, 2)

# for a haploid locus
exptdNumAlleles(40, 1, 1)

# double theta
exptdNumAlleles(40, 2, 1)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Ewens, W. 1972. The sampling theory of selectively neutral
  alleles. Theoretical Population Biology 3:87-112. Eqns. 11 and 24.
}

