% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_time-dep.R
\name{simdata_time_dep}
\alias{simdata_time_dep}
\title{Simulation function for continuous trait with time-dependant coefficients.}
\usage{
simdata_time_dep(N = 10, f = list(at = "-0.05", f1t = "80", Qt = "2e-8", ft
  = "80", bt = "5", mu0t = "1e-3"), step = 1, tstart = 30, tend = 105,
  ystart = 80, sd0 = 1, nobs = NULL, format = "short")
}
\arguments{
\item{N}{Number of individuals.}

\item{f}{a list of formulas that define age (time) - dependency. Default: list(at="a", f1t="f1", Qt="Q*exp(theta*t)", ft="f", bt="b", mu0t="mu0*exp(theta*t)")}

\item{step}{An interval between two observations, a random uniformally-distributed value is then added to this step.}

\item{tstart}{Starting time (age).
Can be a number (30 by default) or a vector of two numbers: c(a, b) - in this case, starting value of time 
is simulated via uniform(a,b) distribution.}

\item{tend}{A number, defines final time (105 by default).}

\item{ystart}{A starting value of covariates.}

\item{sd0}{A standard deviation for modelling the next covariate value, sd0 = 1 by default.}

\item{nobs}{A number of observations (lines) for individual observations.}

\item{format}{Data format: "short" (default), "long".}
}
\value{
A table with simulated data.
}
\description{
Simulation function for continuous trait with time-dependant coefficients.
}
\examples{
library(stpm)
dat <- simdata_time_dep(N=100)
head(dat)

}
\references{
Yashin, A. et al (2007), Health decline, aging and mortality: how are they related? 
Biogerontology, 8(3), 291-302.<DOI:10.1007/s10522-006-9073-3>.
}
