% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_model_probs.R
\name{gam_model_probs}
\alias{gam_model_probs}
\title{Calculates the \verb{model probabilities of the different GAM models generated by }evaluate_models`}
\usage{
gam_model_probs(res_tab, n = 10)
}
\arguments{
\item{res_tab}{a table generated by \code{evaluate_models}}

\item{n}{the number of models to retain and generate probabilities for}
}
\value{
A ranked data table in \code{tibble} format of the top \code{n} models, their form, BIC and model or (\code{Pr(M|D)}) or relative (\code{Pr(M)}) probability value. Model probability indicates the probability of the each model being the correct model and the relative probabilities provide a measure of the doubt about the differences in model specification, when compared to the best or highest ranked model. The relative probabilities are needed when large BIC values generate near zero probability values.
}
\description{
Calculates the \verb{model probabilities of the different GAM models generated by }evaluate_models`
}
\examples{
library(dplyr)
library(purrr)
library(glue)
library(mgcv)
data(productivity)
input_data = productivity |> filter(year == "1970")
svc_res_gam = evaluate_models(input_data, STVC = FALSE)
mod_comp_svc <- gam_model_probs(svc_res_gam, n = 10)
# print out the terms and probabilities
mod_comp_svc|> select(-f)
}
