% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{StepPenalL2}
\alias{StepPenalL2}
\title{Stepwise forward variable selection using penalized regression.}
\usage{
StepPenalL2(Data, lamda, w, standardize = TRUE)
}
\arguments{
\item{Data}{should have the following structure: the first column must be the binary response variable y.}

\item{lamda}{the tuning penalty parameter}

\item{w}{the weight parameter for the sum (1-w)L0+ wL2}

\item{standardize}{Logical flag for the predictors' standardization, prior to fitting the model.
Default is standardize=TRUE}
}
\value{
a list with the shrinked coefficients and the names of the selected variables, i.e those variables with
an estimated coefficient different from zero.
}
\description{
Stepwise forward variable selection based on the combination of L2 and L0 penalties.
The optimization is done using the "BFGS" method in stats::optim
}
\details{
lamda and w  parameters need to be tuned by cross-Validation using stepPenal::tuneParam
}
\examples{
# use the StepPenal function on a simulated dataset, with given lamda and w.

set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=TRUE)

before <- Sys.time()
stepPenalL2 <- StepPenalL2(Data=simData, lamda=1.5, w=0.6)
after <- Sys.time()
after-before

(varstepPenal<- stepPenalL2$coeffP)
}
\seealso{
\code{\link[stats]{optim}}
}

