% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_stcos_demo.R
\name{prepare_stcos_demo}
\alias{prepare_stcos_demo}
\title{Prepare Demo Data for STCOS Model}
\usage{
prepare_stcos_demo(num_knots_sp = 200, basis_mc_reps = 200,
  eigval_prop = 0.65)
}
\arguments{
\item{num_knots_sp}{Number of spatial knots to use in areal space-time
basis.}

\item{basis_mc_reps}{Number of monte carlo reps to use in areal space-time
basis.}

\item{eigval_prop}{Proportion of variability to keep in dimension reduction
of basis expansions.}
}
\value{
A list containing the following:
\itemize{
\item \code{z} direct estimates.
\item \code{v} direct variance estimates.
\item \code{H} overlap matrix.
\item \code{S} design matrix of basis expansion.
\item \code{K} covariance matrix of the random effect.
}
}
\description{
Create demo data based on ACS example, making a few simple model choices.
Uses functions in the package to create model terms from shapefiles.
}
\examples{
\dontrun{
out = prepare_stcos_demo()
}
}
