% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rfca.R
\name{rfca}
\alias{rfca}
\title{Carry out RFCA}
\usage{
rfca(data, outcome, case.ids, fuzzy, ntree, mtry, inter.func,
clust.iter.max, clust.nstart, clust.alg, qca.style, ...)
}
\arguments{
\item{data}{a data frame}

\item{outcome}{a character string giving the name of the outcome}

\item{case.ids}{a character vector giving the names of case identifiers}

\item{fuzzy}{logical; if TRUE, data will be dichotomized around the median}

\item{ntree}{the number of trees to be grown}

\item{mtry}{the number of variables to try at each split}

\item{inter.func}{a function detailing how variable values should be combined
to create interaction values}

\item{clust.iter.max}{the maximum number of iterations allowed in \code{stats::kmeans()}}

\item{clust.nstart}{number of random sets to be chosen in \code{stats::kmeans()}}

\item{clust.alg}{the clustering algorithm used by \code{stats::kmeans()}}

\item{qca.style}{logical; if TRUE, return QCA-style printed solutions}

\item{...}{arguments passed to \code{randomForest()}}
}
\value{
Returns a vector of variable names
}
\description{
\code{rfca} carries out Random Forest Comparative Analysis (RFCA) as detailed
in Krogslund & Michael (2014)
}
\examples{
# Load data
data(hicks_29)

# Run RFCA
a<-rfca(data = hicks_29, outcome = "CON", case.ids = "Case", ntree = 100, mtry = 5)

# Increase the number of trees grown and variables tried at each split
a<-rfca(data = hicks_29, outcome = "CON", case.ids = "Case", ntree = 100, mtry = 5)

# Load data
data(hh)

# Run RFCA
a<-rfca(data = hh, outcome = "success", case.ids = "Country", fuzzy = TRUE,
ntree = 100, mtry = 5)
}

