% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caret_infer.R
\name{caret_infer}
\alias{caret_infer}
\title{QCA-style Inference with Predictive Models}
\usage{
caret_infer(data, case.ids, outcome, inter.func, type, clust.iter.max,
clust.nstart, clust.alg, qca.style, ...)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{a character vector giving the names of case identifiers}

\item{outcome}{a character string giving the name of the outcome}

\item{inter.func}{a function detailing how variable values should be combined
to create interaction values}

\item{type}{one of either "c" for classification prediction or "r" for regression prediction}

\item{clust.iter.max}{the maximum number of iterations allowed in \code{kmeans()}}

\item{clust.nstart}{number of random sets to be chosen in \code{kmeans()}}

\item{clust.alg}{the clustering algorithm used by \code{kmeans()}}

\item{qca.style}{logical; if TRUE, return QCA-style printed solutions}

\item{...}{arguments passed to \code{caret::train()}}
}
\value{
Returns a named list containing the following elements:

\item{model}{a \code{caret} object of class "train"}
\item{imp.scores}{a vector of unscaled variable importance scores}
\item{solutions}{a vector of QCA-style sufficient conditions}
}
\description{
\code{caret_infer} produces QCA-style solutions using models from the
\code{caret} package and methods detailed in Krogslund & Michael (2014)
data, case.ids, outcome, inter.func, type, clust.iter.max, clust.nstart, clust.alg, qca.style
}
\examples{
### NOTE: Not Run

# Load data
data(hicks_29)

# QCA-style inference using a Linear Support Vector Machine
#a<-caret_infer(data = hicks_20, case.ids = "Case", outcome = "CON", type = "c", method="svmLinear")

# Examine solutions
#a$solutions

# QCA-style inference using Naive Bayes
#a<-caret_infer(data = hicks_20, case.ids = "Case", outcome = "CON", type = "c", method="nb")

# Examine solutions
#a$solutions

# QCA-style inference using Neural Networks
#a<-caret_infer(data = hicks_20, case.ids = "Case", outcome = "CON", type = "c", method="nnet")

# Examine solutions
#a$solutions
}

