% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_extractor.R
\name{bf_extractor}
\alias{bf_extractor}
\title{Extract Bayes Factors from \code{BayesFactor} model object.}
\usage{
bf_extractor(bf.object, conf.level = 0.95, k = 2L, top.text = NULL, ...)
}
\arguments{
\item{bf.object}{An object from \code{BayesFactor} package.}

\item{conf.level}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{...}{Additional arguments passed to
\code{\link[parameters:model_parameters.BFBayesFactor]{parameters::model_parameters.BFBayesFactor()}}.}
}
\description{
Extract Bayes Factors from \code{BayesFactor} model object.
}
\note{
\emph{Important}: don't enter \code{1/bf.object} to extract results for null
hypothesis; doing so will return wrong results.
}
\examples{
\donttest{
# setup
library(statsExpressions)
set.seed(123)

# creating a `BayesFactor` object
bf_obj <-
  BayesFactor::anovaBF(
    formula = Sepal.Length ~ Species,
    data = iris,
    progress = FALSE
  )

# extracting Bayes Factors in a dataframe
bf_extractor(bf_obj)
}
}
