% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustments.R
\name{get_stats19_adjustments}
\alias{get_stats19_adjustments}
\title{Download and read-in severity adjustment factors}
\usage{
get_stats19_adjustments(
  data_dir = get_data_directory(),
  u = paste0("http://data.dft.gov.uk/road-accidents-safety-data/",
    "accident-and-casualty-adjustment-2004-to-2019.zip"),
  filename = "cas_adjustment_lookup_2019.csv",
  adj_folder = "adjustment-data"
)
}
\arguments{
\item{data_dir}{Where sets of downloaded data would be found.}

\item{u}{The URL of the zip file with adjustments to download}

\item{filename}{The file name of the .csv file in the unzipped folder to read in}

\item{adj_folder}{The folder name where R will look for the unzipped adjustment files}
}
\description{
See the DfT's documentation on adjustment factors
\href{https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/833813/annex-update-severity-adjustments-methodology.pdf}{Annex: Update to severity adjustments methodology}.
}
\details{
See \href{https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/820588/severity-reporting-methodology-final-report.odt}{Estimating and adjusting for changes in the method of severity reporting for road accidents and casualty data: final report}
for details.
}
\examples{
\donttest{
adjustment = get_stats19_adjustments()
}
}
