% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.lc.mean.ws}
\alias{size.test.lc.mean.ws}
\title{Sample size for a test of a within-subjects mean linear contrast}
\usage{
size.test.lc.mean.ws(alpha, pow, var, es, cor, q)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average variance of measurements}

\item{es}{planning value of linear contrast of means}

\item{cor}{planning value of average correlation between measurements}

\item{q}{vector of with-subjects contrast coefficients}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a linear contrast of population
means with desired power in a within-subjects design. Set the variance
planning value to the largest value within a plausible range for a
conservatively large sample size. Set the correlation planning value to the
smallest value within a plausible range for a conservatively large sample
size.
}
\examples{
q <- c(.5, .5, -.5, -.5)
size.test.lc.mean.ws(.05, .90, 50.7, 2, .8, q)

# Should return:
#      Sample size
# [1,]          29
 

}
