% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.phi}
\alias{ci.phi}
\title{Confidence interval for a phi coefficient}
\usage{
ci.phi(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of phi coefficient
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a phi coefficient. This function requires
the frequency counts from a 2 x 2 contingency table for two dichotomous
variables. This measure of association assumes that both dichotomous
variables are naturally dichotomous.
}
\examples{
ci.phi(.05, 229, 28, 96, 24)

# Should return:
#       Estimate         SE         LL        UL
# [1,] 0.1229976 0.05746271 0.01037273 0.2356224


}
\references{
\insertRef{Bishop1975}{statpsych}
}
