/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.DoubleArray;
import blbutil.FloatArray;
import ints.IntArray;
import vcf.GeneticMap;
import vcf.Marker;
import vcf.Markers;

public class MarkerMap {
    private final DoubleArray genPos;
    private final FloatArray genDist;

    public static MarkerMap create(GeneticMap geneticMap, Markers markers) {
        return new MarkerMap(GeneticMap.genPos(geneticMap, markers));
    }

    public static MarkerMap create(GeneticMap geneticMap, double d, Markers markers) {
        return new MarkerMap(GeneticMap.genPos(geneticMap, d, markers));
    }

    public static double meanSingleBaseGenDist(GeneticMap geneticMap, Markers markers) {
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.size() - 1);
        if (marker.chromIndex() != marker2.chromIndex()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (marker.pos() == marker2.pos()) {
            String string = "Window has only one position: CHROM=" + marker.chrom() + " POS=" + marker.pos();
            throw new IllegalArgumentException(string);
        }
        return Math.abs(geneticMap.genPos(marker2) - geneticMap.genPos(marker)) / (double)Math.abs(marker2.pos() - marker.pos());
    }

    private MarkerMap(double[] dArray) {
        this.genPos = new DoubleArray(dArray);
        this.genDist = MarkerMap.genDist(dArray);
    }

    public MarkerMap restrict(int[] nArray) {
        double[] dArray = new double[nArray.length];
        dArray[0] = this.genPos.get(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[i - 1]) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            dArray[i] = this.genPos.get(nArray[i]);
        }
        return new MarkerMap(dArray);
    }

    public MarkerMap restrict(IntArray intArray) {
        double[] dArray = new double[intArray.size()];
        dArray[0] = this.genPos.get(intArray.get(0));
        int n = intArray.size();
        for (int i = 1; i < n; ++i) {
            if (intArray.get(i) <= intArray.get(i - 1)) {
                throw new IllegalArgumentException(String.valueOf(intArray.get(i)));
            }
            dArray[i] = this.genPos.get(intArray.get(i));
        }
        return new MarkerMap(dArray);
    }

    private static FloatArray genDist(double[] dArray) {
        float f = 1.0E-7f;
        float[] fArray = new float[dArray.length];
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = (float)(dArray[i] - dArray[i - 1]);
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
        }
        return new FloatArray(fArray);
    }

    public DoubleArray genPos() {
        return this.genPos;
    }

    public FloatArray genDist() {
        return this.genDist;
    }

    public FloatArray pRecomb(float f) {
        if ((double)f <= 0.0 || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        double d = -f;
        float[] fArray = new float[this.genDist.size()];
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = (float)(-Math.expm1(d * (double)this.genDist.get(i)));
        }
        return new FloatArray(fArray);
    }
}

