/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromInterval;
import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.InputIt;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.Bref3It;
import imp.ImpData;
import imp.ImpLS;
import imp.StateProbs;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import main.Par;
import main.RunStats;
import main.WindowWriter;
import phase.FixedPhaseData;
import phase.PhaseBaum1;
import phase.PhaseData;
import phase.PhaseLS;
import vcf.AllData;
import vcf.Data;
import vcf.FilterUtil;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.IntervalVcfIt;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGTRec;
import vcf.RefIt;
import vcf.TargetData;
import vcf.VcfIt;
import vcf.XRefGT;

public class Main {
    private static final String VERSION = "(version 5.2)";
    public static final String PROGRAM = "beagle.28Jun21.220.jar";
    public static final String COMMAND = "java -jar beagle.28Jun21.220.jar";
    public static final String COPYRIGHT = "Copyright (C) 2014-2021 Brian L. Browning";
    public static final String SHORT_HELP = "beagle.28Jun21.220.jar (version 5.2)" + Const.nl + "Copyright (C) 2014-2021 Brian L. Browning" + Const.nl + "Enter \"" + "java -jar beagle.28Jun21.220.jar" + "\" to list command line argument";
    private final Par par;
    private final GeneticMap genMap;
    private final Data data;
    private final RunStats runStats;
    private final WindowWriter windowWriter;
    private final Random rand;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        if (stringArray.length == 0) {
            System.out.println("beagle.28Jun21.220.jar (version 5.2)");
            System.out.println(COPYRIGHT);
            System.out.println(Par.usage());
            System.exit(0);
        }
        Par par = Main.parameters(stringArray);
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(par.nthreads()));
        RunStats runStats = new RunStats(par);
        runStats.printStartInfo();
        try (Data data = Main.data(par, runStats);
             WindowWriter windowWriter = new WindowWriter(par, data.targGT().samples());){
            Main main = new Main(par, data, windowWriter, runStats);
            main.phaseAndImpute();
            runStats.printSummaryAndClose(data.nTargMarkersSoFar(), data.nMarkersSoFar());
        }
    }

    private Main(Par par, Data data, WindowWriter windowWriter, RunStats runStats) {
        assert (par != null);
        assert (data != null);
        assert (windowWriter != null);
        assert (runStats != null);
        this.par = par;
        this.genMap = data.genMap();
        this.data = data;
        this.runStats = runStats;
        this.windowWriter = windowWriter;
        this.rand = new Random(par.seed());
    }

    private static Data data(Par par, RunStats runStats) {
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        ChromInterval chromInterval = par.chromInt();
        if (par.ref() == null) {
            Supplier<SampleFileIt<GTRec>> supplier = () -> Main.targIt(par, filter2, filter, chromInterval);
            return TargetData.targetData(par, supplier);
        }
        SampleFileIt<GTRec> sampleFileIt = Main.targIt(par, filter2, filter, chromInterval);
        Supplier<SampleFileIt<RefGTRec>> supplier = Main.refSupplier(par, filter2, filter, chromInterval, runStats);
        return AllData.allData(supplier, sampleFileIt, par);
    }

    private void phaseAndImpute() {
        this.runStats.printSampleSummary(this.data);
        GT gT = null;
        int n = 0;
        do {
            if (++n > 1) {
                this.data.advanceWindow();
            }
            this.runStats.printWindowUpdate(this.data);
            GT gT2 = this.phaseTarg(gT);
            this.printOutput(this.data, gT2);
            gT = this.phasedOverlap(this.data, gT2);
        } while (this.data.canAdvanceWindow());
    }

    private GT phaseTarg(GT gT) {
        if (this.data.targGT().isPhased()) {
            return XRefGT.fromPhasedGT(this.data.targGT(), this.par.nthreads());
        }
        PhaseData phaseData = this.phaseStage1Variants(gT);
        return this.phaseStage2Variants(phaseData);
    }

    private PhaseData phaseStage1Variants(GT gT) {
        FixedPhaseData fixedPhaseData = new FixedPhaseData(this.par, this.genMap, this.data, gT);
        PhaseData phaseData = new PhaseData(fixedPhaseData, this.rand.nextLong());
        int n = this.par.burnin() + this.par.iterations();
        double d = 0.01;
        while (phaseData.it() < n) {
            long l = System.nanoTime();
            PhaseLS.runStage1(phaseData);
            if (phaseData.it() == this.par.burnin()) {
                this.runStats.printEstimatedNe(phaseData.ne());
            }
            this.runStats.printStage1Info(phaseData.it(), System.nanoTime() - l);
            phaseData.incrementIt();
            double d2 = PhaseBaum1.getAndResetSwapRate();
            if (phaseData.it() >= this.par.burnin() || !(d2 <= d)) continue;
            phaseData.advanceToFirstPhasingIt();
        }
        return phaseData;
    }

    private GT phaseStage2Variants(PhaseData phaseData) {
        if (phaseData.fpd().stage1To2().size() == phaseData.fpd().targGT().nMarkers()) {
            return phaseData.estPhase().phasedHaps();
        }
        long l = System.nanoTime();
        GT gT = PhaseLS.runStage2(phaseData);
        this.runStats.printStage2Info(System.nanoTime() - l);
        return gT;
    }

    private void printOutput(Data data, GT gT) {
        assert (this.par.gt() != null);
        int n = this.par.nthreads();
        if (data.nMarkers() == data.targGT().nMarkers() || !this.par.impute()) {
            int n2 = data.markerIndices().prevTargSplice();
            int n3 = data.markerIndices().nextTargSplice();
            this.windowWriter.printPhased(gT, n2, n3, n);
        } else {
            long l = System.nanoTime();
            ImpData impData = new ImpData(this.par, data, gT, this.genMap);
            AtomicReferenceArray<StateProbs> atomicReferenceArray = ImpLS.stateProbs(impData);
            int n4 = data.markerIndices().prevSplice();
            int n5 = data.markerIndices().nextSplice();
            this.windowWriter.printImputed(impData, n4, n5, atomicReferenceArray);
            this.runStats.imputationNanos(System.nanoTime() - l);
            this.runStats.printImputationUpdate();
        }
    }

    private GT phasedOverlap(Data data, GT gT) {
        assert (gT.isPhased());
        int n = data.markerIndices().nextTargOverlap();
        int n2 = data.markerIndices().nextTargSplice();
        int n3 = n2 - n;
        if (n3 == 0) {
            return null;
        }
        Markers markers = gT.markers().restrict(n, n2);
        int[] nArray = IntStream.range(n, n2).toArray();
        return gT.restrict(markers, nArray);
    }

    private static SampleFileIt<GTRec> targIt(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval) {
        InputIt inputIt = InputIt.fromGzipFile(par.gt());
        SampleFileIt<GTRec> sampleFileIt = VcfIt.create(inputIt, filter2, filter, VcfIt.TO_LOWMEM_GT_REC);
        if (chromInterval != null) {
            sampleFileIt = new IntervalVcfIt<GTRec>(sampleFileIt, chromInterval);
        }
        return sampleFileIt;
    }

    private static Supplier<SampleFileIt<RefGTRec>> refSupplier(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval, RunStats runStats) {
        Filter<Marker> filter3 = Main.updateMarkerFilter(par, filter, filter2, chromInterval);
        return () -> {
            SampleFileIt<RefGTRec> sampleFileIt;
            Object object;
            String string = par.ref().toString();
            if (string.endsWith(".bref")) {
                object = Const.nl + "ERROR: bref format (.bref) is not supported" + Const.nl + "       Reference files should be in bref3 format (.bref3)";
                Utilities.exit((String)object);
            }
            if (string.endsWith(".bref3")) {
                sampleFileIt = new Bref3It(par.ref(), filter3);
            } else {
                if (!string.endsWith(".vcf") && !string.endsWith(".vcf.gz")) {
                    runStats.println(Const.nl + "WARNING: unrecognized reference file type (expected \".bref3\", \".vcf\", or \".vcf.gz\")" + Const.nl);
                }
                object = InputIt.fromGzipFile(par.ref());
                sampleFileIt = RefIt.create((FileIt<String>)object, filter2, filter3);
            }
            if (chromInterval != null) {
                sampleFileIt = new IntervalVcfIt<RefGTRec>(sampleFileIt, chromInterval);
            }
            return sampleFileIt;
        };
    }

    private static Filter<Marker> updateMarkerFilter(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval) {
        if (par.impute()) {
            return filter;
        }
        HashSet<Marker> hashSet = new HashSet<Marker>(50000);
        try (SampleFileIt<GTRec> sampleFileIt = Main.targIt(par, filter, filter2, chromInterval);){
            while (sampleFileIt.hasNext()) {
                hashSet.add(((GTRec)sampleFileIt.next()).marker());
            }
        }
        return Filter.includeFilter(hashSet);
    }

    private static Par parameters(String[] stringArray) {
        Par par = new Par(stringArray);
        Main.checkOutputPrefix(par);
        if ((double)par.window() < 1.1 * (double)par.overlap()) {
            String string = SHORT_HELP + Const.nl + Const.nl + "ERROR: The \"window\" parameter must be at least 1.1 times the \"overlap\" parameter" + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        return par;
    }

    private static void checkOutputPrefix(Par par) {
        String string;
        Object object;
        File file = new File(par.out());
        if (file.isDirectory()) {
            object = "ERROR: \"out\" parameter cannot be a directory: \"" + par.out() + "\"";
            Utilities.exit(Par.usage() + (String)object);
        }
        if (((File)(object = new File(par.out() + ".vcf.gz"))).equals(par.ref())) {
            string = "ERROR: VCF output file equals input file: " + par.ref();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gt())) {
            string = "ERROR: VCF output file equals input file: " + par.gt();
            Utilities.exit(Par.usage() + string);
        }
    }
}

