% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics.r
\name{survey_ratio}
\alias{survey_ratio}
\title{Calculate the ratio and its variation using survey methods}
\usage{
survey_ratio(numerator, denominator, na.rm = FALSE, vartype = c("se",
  "ci", "var", "cv"), level = 0.95, deff = FALSE, df = NULL,
  .svy = current_svy(), ...)
}
\arguments{
\item{numerator}{The numerator of the ratio}

\item{denominator}{The denominator of the ratio}

\item{na.rm}{A logical value to indicate whether missing values should be dropped}

\item{vartype}{Report variability as one or more of: standard error ("se", default),
confidence interval ("ci"), variance ("var") or coefficient of variation
("cv").}

\item{level}{A single number or vector of numbers indicating the confidence level}

\item{deff}{A logical value to indicate whether the design effect should be returned.}

\item{df}{(For vartype = "ci" only) A numeric value indicating the degrees of freedom
for t-distribution. The default (NULL) uses \code{\link[survey]{degf}},
but Inf is the usual survey package's default (except in
\code{\link[survey]{svyciprop}}.}

\item{.svy}{A \code{tbl_svy} object. When called from inside a summarize function
the default automatically sets the survey to the current survey.}

\item{...}{Ignored}
}
\description{
Calculate ratios from complex survey data. A wrapper
around \code{\link[survey]{svyratio}}. \code{survey_ratio}
should always be called from \code{\link{summarise}}.
}
\examples{
library(survey)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata \%>\%
  summarise(enroll = survey_ratio(api00, api99, vartype = c("ci", "cv")))

dstrata \%>\%
  group_by(awards) \%>\%
  summarise(api00 = survey_ratio(api00, api99))

# level takes a vector for multiple levels of confidence intervals
dstrata \%>\%
  summarise(enroll = survey_ratio(api99, api00, vartype = "ci", level = c(0.95, 0.65)))

# Note that the default degrees of freedom in srvyr is different from
# survey, so your confidence intervals might not exactly match. To
# replicate survey's behavior, use df = Inf
dstrata \%>\%
  summarise(srvyr_default = survey_total(api99, vartype = "ci"),
            survey_defualt = survey_total(api99, vartype = "ci", df = Inf))

comparison <- survey::svytotal(~api99, dstrata)
confint(comparison) # survey's default
confint(comparison, df = survey::degf(dstrata)) # srvyr's default

}
