% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{msg}
\alias{msg}
\alias{spsinfo}
\alias{spswarn}
\alias{spserror}
\title{pretty logging message}
\usage{
msg(
  msg,
  level = "INFO",
  .other_color = NULL,
  info_text = "INFO",
  warning_text = "WARNING",
  error_text = "ERROR",
  use_color = TRUE
)

spsinfo(msg, verbose = NULL)

spswarn(msg)

spserror(msg)
}
\arguments{
\item{msg}{a character string of message or a vector of character strings,
each item in the vector presents one line of words}

\item{level}{typically, one of "INFO", "WARNING", "ERROR", not case sensitive.
Other custom levels will work too.}

\item{.other_color}{hex color code or named colors, when levels are not in
"INFO", "WARNING", "ERROR", this value will be used}

\item{info_text}{info level text prefix, use with "INFO" level}

\item{warning_text}{warning level text prefix, use with "WARNING" level}

\item{error_text}{error level text prefix, use with "ERROR" level}

\item{use_color}{bool, default \code{TRUE}, to use color if supported?}

\item{verbose}{bool, default get from sps project options, can be overwritten}
}
\value{
see description and details
}
\description{
If
\enumerate{
\item \code{use_color = TRUE} or
\item under SPS main package \code{use_crayon}option is \code{TRUE}
\item In a console that supports colors
Then the message will be colorful, other wise no color
}

"INFO" level spawns \code{message}, "WARNING" is \code{warning}, "ERROR" spawns \code{stop},
other levels use \code{cat}.

\code{spsinfo}, \code{spswarn}, \code{spserror} are higher level wrappers of \code{msg}. The
only difference is they have \verb{SPS-} prefix.

\code{spsinfo} has an additional
arg \code{verbose}. This arg works similarly to all other \code{verbose} args in
SPS:
\enumerate{
\item if not specified, it follows the project option. If SPS option \code{verbose} is
set to \code{TRUE}, message will be displayed; if \code{FALSE}, mute the message.
\item It can be be forced to \code{TRUE} and \code{FALSE}. \code{TRUE} will forcibly generate the msg, and \code{FALSE}
will mute the message.
}
}
\details{
\enumerate{
\item If \code{use_color} is \code{TRUE}, output message will forcibly use color if the console has color
support, ignore SPS \code{use_crayon} option.
\item If \code{use_color} is \code{FALSE}, but you are using within SPS framework, the \code{use_crayon} option
is set to \code{TRUE}, color will be used.
\item Otherwise message will be no color.
}
}
\examples{
msg("this is info")
msg("this is warning", "warning")
try(msg("this is error", "error"))
msg("this is another level", "my level", "green")
spsinfo("some msg, verbose false", verbose = FALSE) # will not show up
spsinfo("some msg, verbose true", verbose = TRUE)
spswarn("sps warning")
try(spserror("sps error"))
}
