% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_convdiags}
\alias{plot_convdiags}
\title{Checking convergence visually}
\usage{
plot_convdiags(fit, burnin = floor(fit$L/10), open_new_window = FALSE,
  maxlag = 100)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{open_new_window}{Open a new window for the plot.}

\item{maxlag}{The maximum lag value to consider. Default is 100.}
}
\description{
Based on a `damcmc_res` object, this function will produce
many graphs to help assess convergence visually,
including running mean plots and
autocorrelation plots for all the parameters. This function calls
\code{\link{plot_runmean}} and \code{\link{plot_autocorr}} for all parameters
so we do not have to it individually.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot_convdiags}
}
\examples{
\donttest{
truemix_surf <- rmixsurf(m = 3, lambda=100, xlim = c(-3,3), ylim = c(-3,3))
plot(truemix_surf)
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
fit = est_mix_damcmc(pp = genPPP, m = 3)
plot_convdiags(fit)}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{plot_runmean}},
\code{\link{plot_autocorr}},
\code{\link{rsppmix}}
}
\author{
Sakis Micheas
}
