% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\name{to_int_surf}
\alias{to_int_surf}
\title{Convert a normal mixture to an intensity surface}
\usage{
to_int_surf(mix, lambda = NULL, win = NULL, return_normmix = FALSE)
}
\arguments{
\item{mix}{Object of class \code{normmix} or \code{intensity_surface}.}

\item{lambda}{Optional parameter treated as the average number of points over the window.}

\item{win}{Optional parameter of class \code{\link[spatstat]{owin}}, defining the window of observation.}

\item{return_normmix}{Logical variable requesting to return a normal mixture (discard \code{lambda}
and \code{win}).}
}
\value{
Object of class \code{intensity_surface}.
}
\description{
This function converts a \code{normmix} object into an \code{intensity_surface}
object. It can also be used to change
the parameters \code{lambda} (average number of points over the window)
or \code{win} (window of observation)
of an \code{intensity_surface} object.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#to_int_surf}

If the class of \code{mix} is \code{normmix},
\code{lambda} and \code{win} are used
to convert \code{mix} into an intensity
surface class. If the class of \code{mix}
is \code{intensity_surface} already, \code{lambda}
and \code{win} are used to change the
original settings for these parameters.
}
\examples{
\donttest{
truemix <- normmix(ps=c(.4, .2,.4), mus=list(c(0.3, 0.3), c(.5,.5),c(0.7, 0.7)),
 sigmas = list(.02*diag(2), .05*diag(2),.01*diag(2)))
intsurf=to_int_surf(truemix, lambda = 100, win = spatstat::square(1))
#plot the true mixture
plot(intsurf,main = "True Poisson intensity surface (mixture of normal components)")
# using the demo_mix normmix object
summary(demo_mix)
demo_surf1=to_int_surf(demo_mix, lambda = 100, win = spatstat::square(1))
plot(demo_surf1)
# using an intensity_surface object
summary(demo_intsurf)
demo_surf2=to_int_surf(demo_intsurf, win = spatstat::square(2))
summary(demo_surf2)
plot(demo_surf2)
demo_surf3=to_int_surf(demo_intsurf, lambda = 50)
plot(demo_surf3)}

}
\seealso{
\code{\link{normmix}},
\code{\link{rnormmix}},
\code{\link[spatstat]{square}}
}
\author{
Yuchen Wang
}
