% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow.R
\name{get_my_followed_artists}
\alias{get_my_followed_artists}
\title{Get the current user’s followed artists.}
\usage{
get_my_followed_artists(limit = 20, after = NULL,
  authorization = get_spotify_authorization_code(),
  include_meta_info = FALSE)
}
\arguments{
\item{limit}{Optional. The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.}

\item{after}{Optional. The last artist ID retrieved from the previous request.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. Getting details of the artists or users the current user follows requires authorization of the \code{user-follow-read} scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\description{
Get the current user’s followed artists.
}
