% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.ala.R
\name{as.ala}
\alias{as.ala}
\title{Coerce occurrence keys to ALA id objects}
\usage{
as.ala(x, ...)
}
\arguments{
\item{x}{Various inputs, including the output from a call to
\code{\link[=occ]{occ()}} (class occdat), \code{\link[=occ2df]{occ2df()}} (class data.frame),
or a list, numeric, alakey, or occkey.}

\item{...}{curl options; named parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
One or more in a list of both class alakey and occkey
}
\description{
Coerce occurrence keys to ALA id objects
}
\examples{
\dontrun{
spnames <- c('Barnardius zonarius', 'Grus rubicunda', 'Cracticus tibicen')
out <- occ(query=spnames, from='ala', limit=2)
(res <- occ2df(out))
(tt <- as.ala(out))
as.ala(x = res$key[1])
}
}
