% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r, R/occ_names.R
\name{spocc_objects}
\alias{spocc_objects}
\alias{print.occdat}
\alias{print.occdatind}
\alias{summary.occdat}
\alias{summary.occdatind}
\alias{print.occnames}
\title{spocc objects and their print, plot, and summary methods}
\usage{
\method{print}{occdat}(x, ...)

\method{print}{occdatind}(x, ...)

\method{summary}{occdat}(object, ...)

\method{summary}{occdatind}(object, ...)

\method{print}{occnames}(x, ...)
}
\arguments{
\item{x}{Input, of class occdatind}

\item{...}{Further args to print, plot or summary methods}

\item{object}{Input to summary methods}

\item{n}{Number of rows to show. If \code{NULL}, the default, will print
all rows if less than option \code{dplyr.print_max}. Otherwise, will
print \code{dplyr.print_min}}
}
\description{
spocc objects and their print, plot, and summary methods
}
\examples{
\dontrun{
# occdat object
res <- occ(query = 'Accipiter striatus', from = 'gbif')
res
print(res)
class(res)

# occdatind object
res$gbif
print(res$gbif)
class(res$gbif)

# print summary of occdat object
summary(res)

# print summary of occdatind object
summary(res$gbif)

# Geometry based searches print slightly differently
bounds <- c(-120, 40, -100, 45)
(res <- occ(from = "idigbio", geometry = bounds, limit = 10))
res$idigbio
## Many bounding boxes/WKT strings
bounds <- list(c(165,-53,180,-29), c(-180,-53,-175,-29))
res <- occ(from = "idigbio", geometry = bounds, limit = 10)
res$idigbio
}
}
\keyword{internal}
