% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gij.polygon.R
\name{Gij.polygon}
\alias{Gij.polygon}
\title{Calculate spatial autocorrelation with OD data and corresponding polygons.}
\usage{
Gij.polygon(df, shape, queen = TRUE, snap = 1, method = "t", R = 1000)
}
\arguments{
\item{df}{A data.frame that contains your Origin-Destination data. The df must consist of "oid" (origin id), "did" (destination id), "n" (flow weight).}

\item{shape}{A shapefile (in a polygon type) that matches to your OD dataframe. The shape must have an "id" column to match your ids in df.}

\item{queen}{A TRUE/FALSE input that is used to calculate \code{spdep}'s spatial contingency (Please view documents of \link[spdep]{poly2nb} for more information).}

\item{snap}{A parameter that is also used to calculate \code{spdep}'s spatial contingency (Please view documents of \link[spdep]{poly2nb} for more information).}

\item{method}{A string value among "o" (origin based), "d" (destination based), and "t" (both way) which determines the way to generate Spatial Weights. The default value is "t".}

\item{R}{An integer value to define how many times you want to execute bootstrapping.}
}
\value{
The result is in the form of a list which includes a dataframe and a \code{sf} object.
Both contain Gij statistics and p-value columns merged to your input df. The geometry type of the latter is linestring.
}
\description{
Calculate spatial autocorrelation with OD data and corresponding polygons.
}
\examples{
# Data manipulation
CA <- spnaf::CA
OD <- cbind(CA$FIPS.County.Code.of.Geography.B, CA$FIPS.County.Code.of.Geography.A)
OD <- cbind(OD, CA$Flow.from.Geography.B.to.Geography.A)
OD <- data.frame(OD)
names(OD) <- c("oid", "did", "n")
OD$n <- as.numeric(OD$n)
OD <- OD[order(OD[,1], OD[,2]),]
head(OD) # check the input df's format

# Load sf polygon
CA_polygon <- spnaf::CA_polygon
head(CA_polygon) # it has a geometry column

# Execution of Gij.polygon with data above and given parameters
\donttest{
result <- Gij.polygon(df = OD, shape = CA_polygon, queen = TRUE, snap = 1,
method = 't', R = 1000)
}

# check the results
\donttest{
head(result[[1]])
head(result[[2]])
}
}
\references{
Berglund, S., & Karlström, A. (1999). Identifying local spatial association in
flow data, Journal of Geographical Systems, 1(3), 219-236. https://doi.org/10.1007/s101090050013
}
