% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalfr.R
\name{sh_apply}
\alias{sh_apply}
\title{Apply a scoring algorithm to each participant using full or split data set}
\usage{
sh_apply(ds, participant_id, fn_sets, fn_score, split_count = 0,
  show_progress = TRUE)
}
\arguments{
\item{ds}{(data frame) data frame containing data to score.}

\item{participant_id}{(character) name of column that identifies participants in ds.}

\item{fn_sets}{(function) receives data from a single participant, should return a list of sets that may be split. Elements of sets that are data frames are split by row. Elements of sets that are lists or vectors are split by element.}

\item{fn_score}{(function) receives full or split sets, should return a single number.}

\item{split_count}{(numeric) Default: 0. If 0, applies fn_score on full set. If > 0, applies fn_score to split sets, split_count times.}

\item{show_progress}{(logical) Default: TRUE. If TRUE, prints current split number each split.}
}
\value{
(data frame) If split_count == 0, returns a data frame with a column for participant_id and a column named "score" for fn_score applied to the full data of each participant. If split_count > 0, it splits each element returned by fn_sets into two halves that differ at most by one in size, applies fn_score on split data, and returns a data frame with a column for participant_id, a column "split" that counts splits, and "score_1" and "score_2" with the score of each split.
}
\description{
Apply a scoring algorithm to each participant using full or split data set
}
\examples{
# N.B. This example uses R script from the vignette: "rapi_sum"
data("ds_rapi", package = "splithalfr")
rapi_fn_sets <- function (ds) {
  return (list(
    items = unlist(ds[paste("V", 1 : 23, sep = "")])
  ))
}
rapi_fn_score <- function (sets) {
  return (sum(sets$items))
}
# Calculate scores per participant on full data
sh_apply(ds_rapi, "twnr", rapi_fn_sets, rapi_fn_score)
# Calculate split scores per participant ten times
sh_apply(ds_rapi, "twnr", rapi_fn_sets, rapi_fn_score, 10)
}
